/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.deployments.BitbucketDeploymentFactory;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentPoster;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStep;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStepDescriptorHelper;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStepExecution;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStepUtils;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironmentType;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class DeploymentStepImpl
extends Step
implements DeploymentStep {
    private final String environmentName;
    private String environmentKey = DeploymentStepUtils.getOrGenerateEnvironmentKey();
    private BitbucketDeploymentEnvironmentType environmentType;
    private String environmentUrl;

    @DataBoundConstructor
    public DeploymentStepImpl(@CheckForNull String environmentName) {
        this.environmentName = StringUtils.stripToNull((String)environmentName);
    }

    public StepExecution start(StepContext context) throws Exception {
        Run run = (Run)context.get(Run.class);
        if (run == null) {
            throw new IllegalArgumentException("StepContext does not contain the Run");
        }
        TaskListener taskListener = (TaskListener)context.get(TaskListener.class);
        if (taskListener == null) {
            throw new IllegalArgumentException("StepContext does not contain the TaskListener");
        }
        BitbucketDeploymentEnvironment environment = this.getEnvironment(run, taskListener);
        return new DeploymentStepExecution(environment, context);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public BitbucketDeploymentEnvironment getEnvironment(Run<?, ?> run, TaskListener listener) {
        return DeploymentStepUtils.getEnvironment(this, run, listener);
    }

    @Override
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @DataBoundSetter
    public void setEnvironmentKey(@CheckForNull String environmentKey) {
        this.environmentKey = DeploymentStepUtils.getOrGenerateEnvironmentKey(environmentKey);
    }

    @Override
    @CheckForNull
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    @CheckForNull
    public String getEnvironmentType() {
        return this.environmentType == null ? null : this.environmentType.name();
    }

    @DataBoundSetter
    public void setEnvironmentType(@CheckForNull String environmentType) {
        this.environmentType = DeploymentStepUtils.normalizeEnvironmentType(environmentType);
    }

    @Override
    @CheckForNull
    public String getEnvironmentUrl() {
        return this.environmentUrl;
    }

    @DataBoundSetter
    public void setEnvironmentUrl(@CheckForNull String environmentUrl) {
        this.environmentUrl = StringUtils.stripToNull((String)environmentUrl);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        @Inject
        private BitbucketDeploymentFactory bitbucketDeploymentFactory;
        @Inject
        private DeploymentPoster deploymentPoster;
        @Inject
        private DeploymentStepDescriptorHelper descriptorHelper;

        @POST
        public FormValidation doCheckEnvironmentKey(@AncestorInPath @CheckForNull Item context, @QueryParameter @CheckForNull String environmentKey) {
            return this.descriptorHelper.doCheckEnvironmentKey(context, environmentKey);
        }

        @POST
        public FormValidation doCheckEnvironmentName(@AncestorInPath @CheckForNull Item context, @QueryParameter @CheckForNull String environmentName) {
            return this.descriptorHelper.doCheckEnvironmentName(context, environmentName);
        }

        @POST
        public FormValidation doCheckEnvironmentType(@AncestorInPath @CheckForNull Item context, @QueryParameter @CheckForNull String environmentType) {
            return this.descriptorHelper.doCheckEnvironmentType(context, environmentType);
        }

        @POST
        public ListBoxModel doFillEnvironmentTypeItems(@AncestorInPath @CheckForNull Item context) {
            return this.descriptorHelper.doFillEnvironmentTypeItems(context);
        }

        @POST
        public FormValidation doCheckEnvironmentUrl(@AncestorInPath @CheckForNull Item context, @QueryParameter @CheckForNull String environmentUrl) {
            return this.descriptorHelper.doCheckEnvironmentUrl(context, environmentUrl);
        }

        public BitbucketDeploymentFactory getBitbucketDeploymentFactory() {
            return this.bitbucketDeploymentFactory;
        }

        public DeploymentPoster getDeploymentPoster() {
            return this.deploymentPoster;
        }

        public String getDisplayName() {
            return "Wrapper step to notify Bitbucket Server of the deployment status.";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(Run.class, Launcher.class, TaskListener.class));
        }

        public String getFunctionName() {
            return "bbs_deploy";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }
}

