/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthGlobalConfiguration;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token.DisplayAccessToken;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token.Messages;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.User;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class OAuthTokenConfiguration
implements Action,
Describable<OAuthGlobalConfiguration> {
    public static final String REVOKE_BUTTON_NAME = "Revoke";
    private Clock clock;
    private ServiceProviderTokenStore tokenStore;
    private User user;

    OAuthTokenConfiguration(Clock clock, ServiceProviderTokenStore tokenStore, User target) {
        this.clock = clock;
        this.tokenStore = tokenStore;
        this.user = target;
    }

    public OAuthTokenConfiguration() {
    }

    @RequirePOST
    public HttpResponse doRevoke(StaplerRequest request) {
        request.getParameterMap().entrySet().stream().filter(e -> ((String[])e.getValue()).length == 1 && ((String[])e.getValue())[0].equals(REVOKE_BUTTON_NAME)).map(Map.Entry::getKey).forEach(t -> this.tokenStore.remove((String)t));
        return HttpResponses.redirectToDot();
    }

    public Descriptor<OAuthGlobalConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.bitbucket_oauth_token_revoke_name();
    }

    @CheckForNull
    public String getIconFileName() {
        return "symbol-lock-closed";
    }

    public List<DisplayAccessToken> getTokens() {
        ArrayList<DisplayAccessToken> tokenList = new ArrayList<DisplayAccessToken>();
        this.user.checkPermission(Jenkins.ADMINISTER);
        this.tokenStore.getAccessTokensForUser(this.user.getId()).forEach(token -> tokenList.add(new DisplayAccessToken((ServiceProviderToken)token, this.clock)));
        return tokenList;
    }

    @CheckForNull
    public String getUrlName() {
        return "tokens";
    }
}

