/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.link;

import com.atlassian.bitbucket.jenkins.internal.link.BitbucketExternalLinkUtils;
import com.atlassian.bitbucket.jenkins.internal.provider.DefaultSCMHeadByItemProvider;
import com.atlassian.bitbucket.jenkins.internal.provider.DefaultSCMSourceByItemProvider;
import com.atlassian.bitbucket.jenkins.internal.provider.SCMHeadByItemProvider;
import com.atlassian.bitbucket.jenkins.internal.provider.SCMSourceByItemProvider;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.scm.SCM;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMHead;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class BitbucketJobLinkActionFactory
extends TransientActionFactory<Job> {
    @Inject
    private BitbucketExternalLinkUtils externalLinkUtils;
    @Inject
    private SCMHeadByItemProvider headProvider;
    @Inject
    private SCMSourceByItemProvider sourceProvider;

    public BitbucketJobLinkActionFactory() {
    }

    public BitbucketJobLinkActionFactory(BitbucketExternalLinkUtils externalLinkUtils, DefaultSCMHeadByItemProvider headProvider, DefaultSCMSourceByItemProvider sourceProvider) {
        this.externalLinkUtils = externalLinkUtils;
        this.headProvider = headProvider;
        this.sourceProvider = sourceProvider;
    }

    public Collection<? extends Action> createFor(Job target) {
        if (target instanceof FreeStyleProject) {
            FreeStyleProject freeStyleProject = (FreeStyleProject)target;
            if (freeStyleProject.getScm() instanceof BitbucketSCM) {
                BitbucketSCMRepository scmRepository2 = ((BitbucketSCM)freeStyleProject.getScm()).getBitbucketSCMRepository();
                return this.externalLinkUtils.createRepoLink(scmRepository2).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
            }
        } else if (target instanceof WorkflowJob) {
            CpsScmFlowDefinition definition;
            WorkflowJob workflowJob = (WorkflowJob)target;
            if (workflowJob.getDefinition() instanceof CpsScmFlowDefinition && (definition = (CpsScmFlowDefinition)workflowJob.getDefinition()).getScm() instanceof BitbucketSCM) {
                BitbucketSCMRepository scmRepository3 = ((BitbucketSCM)definition.getScm()).getBitbucketSCMRepository();
                return this.externalLinkUtils.createRepoLink(scmRepository3).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
            }
            if (this.getWorkflowParent(workflowJob) instanceof WorkflowMultiBranchProject) {
                SCMHead head = this.headProvider.findHead((Item)workflowJob);
                if (head == null) {
                    return Collections.emptyList();
                }
                Optional<BitbucketSCMRepository> repository = Stream.of(this.getScmSource(workflowJob), this.getScmStep(workflowJob)).filter(Optional::isPresent).map(Optional::get).findFirst();
                Optional<List> externalLink = head instanceof BitbucketPullRequestSCMHead ? repository.flatMap(scmRepository -> this.externalLinkUtils.createPullRequestLink((BitbucketSCMRepository)scmRepository, ((BitbucketPullRequestSCMHead)head).getId())) : repository.flatMap(scmRepository -> this.externalLinkUtils.createBranchDiffLink((BitbucketSCMRepository)scmRepository, head.getName()));
                return externalLink.map(Collections::singletonList).orElse(Collections.emptyList());
            }
            if (this.getWorkflowSCMs(workflowJob).stream().anyMatch(BitbucketSCM.class::isInstance)) {
                return this.getScmStep(workflowJob).flatMap(scmRepository -> this.externalLinkUtils.createRepoLink((BitbucketSCMRepository)scmRepository)).map(Collections::singletonList).orElse(Collections.emptyList());
            }
        }
        return Collections.emptySet();
    }

    public Class<Job> type() {
        return Job.class;
    }

    @VisibleForTesting
    ItemGroup getWorkflowParent(WorkflowJob job) {
        return job.getParent();
    }

    @VisibleForTesting
    Collection<? extends SCM> getWorkflowSCMs(WorkflowJob job) {
        return job.getSCMs();
    }

    private Optional<BitbucketSCMRepository> getScmStep(WorkflowJob workflowJob) {
        return this.getWorkflowSCMs(workflowJob).stream().filter(scm -> scm instanceof BitbucketSCM).map(scm -> ((BitbucketSCM)((Object)scm)).getBitbucketSCMRepository()).findFirst();
    }

    private Optional<BitbucketSCMRepository> getScmSource(WorkflowJob workflowJob) {
        return Optional.ofNullable(this.sourceProvider.findSource((Item)workflowJob)).filter(BitbucketSCMSource.class::isInstance).map(scmSource -> ((BitbucketSCMSource)((Object)scmSource)).getBitbucketSCMRepository());
    }
}

