/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlassianServerCapabilities {
    public static final String WEBHOOK_CAPABILITY_KEY = "webhooks";
    public static final String RICH_BUILDSTATUS_CAPABILITY_KEY = "build";
    public static final String DEPLOYMENTS_CAPABILITY_KEY = "deployment";
    private final String application;
    private final Map<String, String> capabilities;

    @JsonCreator
    public AtlassianServerCapabilities(@JsonProperty(value="application") String application, @JsonProperty(value="capabilities") Map<String, String> capabilities) {
        this.application = application;
        this.capabilities = Collections.unmodifiableMap(capabilities);
    }

    @Nullable
    public String getApplication() {
        return this.application;
    }

    public boolean isBitbucketServer() {
        return "stash".equals(this.application);
    }

    public Map<String, String> getCapabilities() {
        return this.capabilities;
    }
}

