/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BitbucketWebhookRequest {
    private final Map<String, String> configuration;
    private final String name;
    private final Set<String> events;
    private final String url;
    private final boolean isActive;

    @JsonCreator
    protected BitbucketWebhookRequest(@JsonProperty(value="name") String name, @JsonProperty(value="events") Set<String> events, @JsonProperty(value="url") String url, @JsonProperty(value="active") boolean isActive) {
        this.name = name;
        this.events = events;
        this.url = url;
        this.isActive = isActive;
        this.configuration = Collections.singletonMap("createdBy", "jenkins");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketWebhookRequest that = (BitbucketWebhookRequest)o;
        return this.isActive == that.isActive && Objects.equals(this.configuration, that.configuration) && Objects.equals(this.name, that.name) && Objects.equals(this.events, that.events) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.name, this.events, this.url, this.isActive);
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public static final class Builder {
        private final Set<String> events;
        private String name;
        private boolean isActive = true;
        private String url;

        public Builder(Collection<String> events) {
            this.events = Collections.unmodifiableSet(new HashSet<String>(events));
        }

        public BitbucketWebhookRequest build() {
            Objects.requireNonNull(this.events, "Specify the webhook events");
            Objects.requireNonNull(this.url, "Specify the Call back URL");
            Objects.requireNonNull(this.name, "Specify the name of the webhook.");
            return new BitbucketWebhookRequest(this.name, this.events, this.url, this.isActive);
        }

        public Builder withIsActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder withCallbackTo(String url) {
            this.url = url;
            return this;
        }
    }
}

