/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequest;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketBranchSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.MinimalPullRequest;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;

public class BitbucketPullRequestSCMHead
extends BitbucketSCMHead
implements ChangeRequestSCMHead2 {
    private static final String PR_ID_PREFIX = "PR-";
    private final String originName;
    private final MinimalPullRequest pullRequest;
    private final String pullRequestId;
    private final BitbucketSCMHead target;

    public BitbucketPullRequestSCMHead(BitbucketPullRequest pullRequest) {
        super(PR_ID_PREFIX + pullRequest.getId(), pullRequest.getFromRef().getLatestCommit(), pullRequest.getUpdatedDate());
        this.originName = pullRequest.getFromRef().getDisplayId();
        this.pullRequest = new MinimalPullRequest(pullRequest);
        this.pullRequestId = Long.toString(pullRequest.getId());
        this.target = new BitbucketBranchSCMHead(pullRequest.getToRef());
    }

    public ChangeRequestCheckoutStrategy getCheckoutStrategy() {
        return ChangeRequestCheckoutStrategy.MERGE;
    }

    @Override
    public String getFullRef() {
        return "refs/heads/" + this.originName;
    }

    public String getId() {
        return this.pullRequestId;
    }

    public BitbucketSCMHead getTarget() {
        return this.target;
    }

    public String getOriginName() {
        return this.originName;
    }

    public MinimalPullRequest getPullRequest() {
        return this.pullRequest;
    }
}

