/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import java.util.Objects;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;

public class BitbucketPullRequestSCMRevision
extends ChangeRequestSCMRevision<BitbucketPullRequestSCMHead> {
    private static final long serialVersionUID = 1L;
    private final String commitHash;

    public BitbucketPullRequestSCMRevision(BitbucketPullRequestSCMHead head) {
        super((SCMHead)head, (SCMRevision)new BitbucketSCMRevision(head.getTarget(), head.getPullRequest().getToLatestCommit()));
        this.commitHash = head.getPullRequest().getFromLatestCommit();
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public boolean equivalent(ChangeRequestSCMRevision<?> o) {
        if (!(o instanceof BitbucketPullRequestSCMRevision)) {
            return false;
        }
        BitbucketPullRequestSCMRevision other = (BitbucketPullRequestSCMRevision)o;
        return this.getHead().equals((Object)other.getHead()) && this.commitHash.equals(other.commitHash);
    }

    protected int _hashCode() {
        return Objects.hash(this.getHead(), this.commitHash);
    }

    public String toString() {
        return this.getTarget() + "+" + this.commitHash;
    }
}

