/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.scm.CloneProtocol;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;

public class BitbucketSCMRepository {
    private final String credentialsId;
    private final String mirrorName;
    private final String projectKey;
    private final String projectName;
    private final String repositoryName;
    private final String repositorySlug;
    private final String serverId;
    private final String sshCredentialsId;

    public BitbucketSCMRepository(@CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @CheckForNull String projectName, @CheckForNull String projectKey, @CheckForNull String repositoryName, @CheckForNull String repositorySlug, @CheckForNull String serverId, @CheckForNull String mirrorName) {
        this.credentialsId = credentialsId;
        this.sshCredentialsId = sshCredentialsId;
        this.projectName = Objects.toString(projectName, "");
        this.projectKey = Objects.toString(projectKey, "");
        this.repositoryName = Objects.toString(repositoryName, "");
        this.repositorySlug = Objects.toString(repositorySlug, "");
        this.serverId = serverId;
        this.mirrorName = Objects.toString(mirrorName, "");
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getMirrorName() {
        return this.mirrorName;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @CheckForNull
    public String getServerId() {
        return this.serverId;
    }

    @CheckForNull
    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    public boolean isMirrorConfigured() {
        return !StringUtils.isBlank((CharSequence)this.mirrorName);
    }

    public boolean isPersonal() {
        return this.projectKey.startsWith("~");
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.projectKey) && StringUtils.isNotBlank((CharSequence)this.projectName) && StringUtils.isNotBlank((CharSequence)this.repositoryName) && StringUtils.isNotBlank((CharSequence)this.repositorySlug) && StringUtils.isNotBlank((CharSequence)this.serverId);
    }

    public CloneProtocol getCloneProtocol() {
        return StringUtils.isBlank((CharSequence)this.sshCredentialsId) ? CloneProtocol.HTTP : CloneProtocol.SSH;
    }

    public String getCloneCredentialsId() {
        return StringUtils.isBlank((CharSequence)this.sshCredentialsId) ? this.credentialsId : this.sshCredentialsId;
    }
}

