/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.annotations.UpgradeHandled;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.CredentialUtils;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.link.BitbucketExternalLink;
import com.atlassian.bitbucket.jenkins.internal.link.BitbucketExternalLinkUtils;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDefaultBranch;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketBranchSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketMirrorHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHeadDiscoveryHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMProbe;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSourceContext;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSourceRequest;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFill;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFillDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidation;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidationDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmHelper;
import com.atlassian.bitbucket.jenkins.internal.scm.CustomGitSCMSource;
import com.atlassian.bitbucket.jenkins.internal.scm.EnrichedBitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.Messages;
import com.atlassian.bitbucket.jenkins.internal.scm.MinimalPullRequest;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketBranchDiscoveryTrait;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketLegacyTraitConverter;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRepositoryMetadataAction;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookMultibranchTrigger;
import com.atlassian.bitbucket.jenkins.internal.trigger.RetryingWebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.AbstractWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookRegistrationFailed;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.plugins.credentials.Credentials;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.browser.BitbucketServer;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BitbucketSCMSource
extends SCMSource {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSource.class.getName());
    @UpgradeHandled(handledBy="static fields not persisted", removeAnnotationInVersion="4.0.0")
    private static final String REFSPEC_DEFAULT = "+refs/heads/*:refs/remotes/@{remote}/*";
    @UpgradeHandled(handledBy="initialize() method", removeAnnotationInVersion="4.0.0")
    private String cloneUrl;
    private transient CustomGitSCMSource gitSCMSource;
    @UpgradeHandled(handledBy="readResolve() method", removeAnnotationInVersion="4.0.0")
    private transient AtomicBoolean initialized = new AtomicBoolean(false);
    private BitbucketSCMRepository repository;
    @UpgradeHandled(handledBy="initialize() method", removeAnnotationInVersion="4.0.0")
    private String selfLink;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private volatile boolean webhookRegistered;

    @DataBoundConstructor
    public BitbucketSCMSource(@CheckForNull String id, @CheckForNull String credentialsId, @CheckForNull String sshCredentialsId, @CheckForNull List<SCMSourceTrait> traits, @CheckForNull String projectName, @CheckForNull String repositoryName, @CheckForNull String serverId, @CheckForNull String mirrorName) {
        super.setId(id);
        if (traits != null) {
            this.traits.addAll(traits);
        }
        this.repository = new BitbucketSCMRepository(credentialsId, sshCredentialsId, projectName, projectName, repositoryName, repositoryName, serverId, mirrorName);
    }

    public BitbucketSCMSource(BitbucketSCMSource oldScm) {
        this(oldScm.getId(), oldScm.getCredentialsId(), oldScm.getSshCredentialsId(), oldScm.getTraits(), oldScm.getProjectName(), oldScm.getRepositoryName(), oldScm.getServerId(), oldScm.getMirrorName());
    }

    public void afterSave() {
        SCMSourceOwner owner;
        super.afterSave();
        this.validateInitialized();
        if (!this.webhookRegistered && this.isValid() && (owner = this.getOwner()) instanceof ComputedFolder) {
            ComputedFolder project = (ComputedFolder)owner;
            DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
            BitbucketServerConfiguration bitbucketServerConfiguration = descriptor.getConfiguration(this.getServerId()).orElseThrow(() -> new BitbucketClientException("Server config not found for input server id " + this.getServerId()));
            List<BitbucketWebhookMultibranchTrigger> triggers = this.getTriggers(project);
            boolean isPullRequestTrigger = triggers.stream().anyMatch(BitbucketWebhookMultibranchTrigger::isPullRequestTrigger);
            boolean isRefTrigger = triggers.stream().anyMatch(BitbucketWebhookMultibranchTrigger::isRefTrigger);
            try {
                descriptor.getRetryingWebhookHandler().register(bitbucketServerConfiguration.getBaseUrl(), bitbucketServerConfiguration.getGlobalCredentialsProvider((Item)owner), this.repository, (Item)owner, isPullRequestTrigger, isRefTrigger);
            }
            catch (WebhookRegistrationFailed webhookRegistrationFailed) {
                LOGGER.severe("Webhook failed to register- token credentials assigned to " + bitbucketServerConfiguration.getServerName() + " do not have admin access. Please reconfigure your instance in the Manage Jenkins -> Settings page.");
            }
        }
    }

    public SCM build(SCMHead head, @CheckForNull SCMRevision revision) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building SCM for " + head.getName() + " at revision " + revision);
        }
        this.validateInitialized();
        GitSCMBuilder builder = new GitSCMBuilder(head, revision, this.cloneUrl, this.repository.getCloneCredentialsId());
        builder.withBrowser((GitRepositoryBrowser)new BitbucketServer(this.selfLink));
        builder.withRefSpec(REFSPEC_DEFAULT);
        builder.withTraits(this.traits);
        return builder.build();
    }

    public BitbucketSCMRepository getBitbucketSCMRepository() {
        return this.repository;
    }

    public Optional<Credentials> getCredentials() {
        return CredentialUtils.getCredentials(this.getCredentialsId(), (Item)this.getOwner());
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.getBitbucketSCMRepository().getCredentialsId();
    }

    public String getMirrorName() {
        return this.getBitbucketSCMRepository().getMirrorName();
    }

    public String getProjectKey() {
        return this.getBitbucketSCMRepository().getProjectKey();
    }

    public String getProjectName() {
        BitbucketSCMRepository repository = this.getBitbucketSCMRepository();
        return repository.isPersonal() ? repository.getProjectKey() : repository.getProjectName();
    }

    public String getRemote() {
        this.validateInitialized();
        return this.cloneUrl;
    }

    public String getRepositoryName() {
        return this.getBitbucketSCMRepository().getRepositoryName();
    }

    public String getRepositorySlug() {
        return this.getBitbucketSCMRepository().getRepositorySlug();
    }

    @CheckForNull
    public String getServerId() {
        return this.getBitbucketSCMRepository().getServerId();
    }

    @CheckForNull
    public String getSshCredentialsId() {
        return this.getBitbucketSCMRepository().getSshCredentialsId();
    }

    public List<SCMSourceTrait> getTraits() {
        return this.traits;
    }

    public boolean isEventApplicable(@CheckForNull SCMHeadEvent<?> event) {
        if (this.getOwner() instanceof ComputedFolder && event != null) {
            ComputedFolder owner = (ComputedFolder)this.getOwner();
            Object payload = event.getPayload();
            if (payload instanceof AbstractWebhookEvent) {
                AbstractWebhookEvent webhookEvent = (AbstractWebhookEvent)payload;
                return owner.getTriggers().values().stream().filter(trg -> trg instanceof BitbucketWebhookMultibranchTrigger).anyMatch(trig -> ((BitbucketWebhookMultibranchTrigger)((Object)trig)).isApplicableForEventType(webhookEvent));
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getBitbucketSCMRepository().isValid() && StringUtils.isNotBlank((CharSequence)this.getRemote());
    }

    public boolean isWebhookRegistered() {
        return this.webhookRegistered;
    }

    public void setWebhookRegistered(boolean webhookRegistered) {
        this.webhookRegistered = webhookRegistered;
    }

    protected SCMProbe createProbe(SCMHead head, @CheckForNull SCMRevision revision) throws IOException {
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        BitbucketServerConfiguration serverConfig = descriptor.getConfiguration(this.getServerId()).get();
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfig.getBaseUrl(), this.getCredentials().orElse(null));
        return new BitbucketSCMProbe(head, scmHelper.getFilePathClient(this.getProjectKey(), this.getRepositorySlug()));
    }

    protected Object readResolve() {
        if (this.traits != null) {
            this.traits = this.traits.stream().map(BitbucketLegacyTraitConverter::maybeConvert).filter(Objects::nonNull).collect(Collectors.toList());
        }
        this.initialized = new AtomicBoolean(false);
        this.validateInitialized();
        return this;
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, TaskListener listener) throws IOException, InterruptedException {
        if (event == null || this.isEventApplicable(event)) {
            if (!this.isValid()) {
                listener.error("The BitbucketSCMSource has been incorrectly configured, and cannot perform a retrieve. Check the configuration before running this job again.");
                return;
            }
            this.validateInitialized();
            this.doRetrieve(criteria, observer, event, listener);
        }
    }

    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        if (head instanceof BitbucketPullRequestSCMHead) {
            return new BitbucketPullRequestSCMRevision((BitbucketPullRequestSCMHead)head);
        }
        if (head instanceof BitbucketBranchSCMHead) {
            return new BitbucketSCMRevision((BitbucketBranchSCMHead)head, ((BitbucketBranchSCMHead)head).getLatestCommit());
        }
        listener.error("Error resolving revision, unsupported SCMHead type " + head.getClass());
        return null;
    }

    protected List<Action> retrieveActions(SCMSourceEvent event, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        Optional<BitbucketServerConfiguration> mayBeServerConf = descriptor.getConfiguration(this.getServerId());
        if (!mayBeServerConf.isPresent()) {
            LOGGER.info("No Bitbucket Server configuration for serverId " + this.getServerId());
            return Collections.emptyList();
        }
        BitbucketServerConfiguration serverConfiguration = mayBeServerConf.get();
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfiguration.getBaseUrl(), this.getCredentials().orElse(null));
        scmHelper.getDefaultBranch(this.repository.getProjectName(), this.repository.getRepositoryName()).ifPresent(defaultBranch -> result.add((Action)new BitbucketRepositoryMetadataAction(this.repository, (BitbucketDefaultBranch)defaultBranch)));
        return result;
    }

    protected List<Action> retrieveActions(SCMHead head, @CheckForNull SCMHeadEvent event, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            ((Actionable)owner).getActions(BitbucketRepositoryMetadataAction.class).stream().filter(action -> action.getBitbucketSCMRepository().equals(this.repository) && StringUtils.equals((CharSequence)action.getBitbucketDefaultBranch().getDisplayId(), (CharSequence)head.getName())).findAny().ifPresent(action -> result.add((Action)new PrimaryInstanceMetadataAction()));
        }
        if (head instanceof BitbucketPullRequestSCMHead) {
            BitbucketPullRequestSCMHead prHead = (BitbucketPullRequestSCMHead)head;
            MinimalPullRequest pullRequest = prHead.getPullRequest();
            DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
            String pullRequestLink = descriptor.getBitbucketExternalLinkUtils().createPullRequestLink(this.getBitbucketSCMRepository(), prHead.getId()).map(BitbucketExternalLink::getUrlName).orElse(null);
            result.add((Action)new ObjectMetadataAction(pullRequest.getTitle(), pullRequest.getDescription(), pullRequestLink));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void validateInitialized() {
        if (!this.initialized.get()) {
            BitbucketSCMSource bitbucketSCMSource = this;
            synchronized (bitbucketSCMSource) {
                if (!this.initialized.get()) {
                    this.initialize();
                    this.initialized.set(true);
                }
            }
        }
    }

    private void doRetrieve(@CheckForNull SCMSourceCriteria criteria, SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, TaskListener listener) throws IOException {
        Set<SCMHead> eventHeads = event == null ? Collections.emptySet() : event.heads((SCMSource)this).keySet();
        BitbucketSCMSourceContext context = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(criteria, observer, this.getCredentials().orElse(null), eventHeads, this.repository, listener).withTraits(this.traits);
        try (BitbucketSCMSourceRequest request = context.newRequest(this, listener);){
            for (BitbucketSCMHeadDiscoveryHandler discoveryHandler : request.getDiscoveryHandlers()) {
                discoveryHandler.discoverHeads().anyMatch(scmHead -> {
                    SCMRevision scmRevision = discoveryHandler.toRevision((SCMHead)scmHead);
                    try {
                        return request.process((SCMHead)scmHead, scmRevision, (arg_0, arg_1) -> ((BitbucketSCMSource)this).newProbe(arg_0, arg_1), new SCMSourceRequest.Witness[]{(head, revision, isMatch) -> listener.getLogger().printf("head: %s, revision: %s, isMatch: %s%n", head, revision, isMatch)});
                    }
                    catch (IOException | InterruptedException e) {
                        listener.error("Error processing request for head: " + scmHead + ", revision: " + scmRevision + ", error: " + e.getMessage());
                        return true;
                    }
                });
            }
        }
    }

    private List<BitbucketWebhookMultibranchTrigger> getTriggers(ComputedFolder<?> owner) {
        return owner.getTriggers().values().stream().filter(BitbucketWebhookMultibranchTrigger.class::isInstance).map(BitbucketWebhookMultibranchTrigger.class::cast).collect(Collectors.toList());
    }

    private void initialize() {
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        Optional<BitbucketServerConfiguration> mayBeServerConf = descriptor.getConfiguration(this.repository.getServerId());
        if (!mayBeServerConf.isPresent()) {
            return;
        }
        BitbucketServerConfiguration serverConfiguration = mayBeServerConf.get();
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfiguration.getBaseUrl(), this.getCredentials().orElse(null));
        if (this.repository.isMirrorConfigured()) {
            EnrichedBitbucketMirroredRepository fetchedRepository = descriptor.createMirrorHandler(scmHelper).fetchRepository(new MirrorFetchRequest(serverConfiguration.getBaseUrl(), (Item)this.getOwner(), this.getCredentialsId(), this.getProjectName(), this.getRepositoryName(), this.getMirrorName()));
            BitbucketRepository underlyingRepo = fetchedRepository.getRepository();
            this.repository = new BitbucketSCMRepository(this.getCredentialsId(), this.getSshCredentialsId(), underlyingRepo.getProject().getName(), underlyingRepo.getProject().getKey(), underlyingRepo.getName(), underlyingRepo.getSlug(), this.getServerId(), fetchedRepository.getMirroringDetails().getMirrorName());
            this.cloneUrl = fetchedRepository.getMirroringDetails().getCloneUrl(this.getBitbucketSCMRepository().getCloneProtocol()).map(BitbucketNamedLink::getHref).orElseGet(() -> underlyingRepo.getCloneUrl(this.getBitbucketSCMRepository().getCloneProtocol()).map(BitbucketNamedLink::getHref).orElse(""));
            this.selfLink = underlyingRepo.getSelfLink();
        } else {
            BitbucketRepository fetchedRepository = scmHelper.getRepository(this.getProjectName(), this.getRepositoryName());
            this.repository = new BitbucketSCMRepository(this.getCredentialsId(), this.getSshCredentialsId(), fetchedRepository.getProject().getName(), fetchedRepository.getProject().getKey(), fetchedRepository.getName(), fetchedRepository.getSlug(), this.getServerId(), "");
            this.cloneUrl = fetchedRepository.getCloneUrl(this.repository.getCloneProtocol()).map(BitbucketNamedLink::getHref).orElse("");
            this.selfLink = fetchedRepository.getSelfLink();
        }
        this.selfLink = this.selfLink.substring(0, Math.max(this.selfLink.lastIndexOf("/browse"), 0));
        if (StringUtils.isBlank((CharSequence)this.cloneUrl)) {
            LOGGER.info("No clone url found for repository: " + this.repository.getRepositoryName());
        }
    }

    @Symbol(value={"BbS"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor
    implements BitbucketScmFormValidation,
    BitbucketScmFormFill {
        private final GitSCMSource.DescriptorImpl gitScmSourceDescriptor = new GitSCMSource.DescriptorImpl();
        @Inject
        private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
        @Inject
        private BitbucketExternalLinkUtils bitbucketExternalLinkUtils;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private BitbucketScmFormFillDelegate formFill;
        @Inject
        private BitbucketScmFormValidationDelegate formValidation;
        @Inject
        private JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
        @Inject
        private RetryingWebhookHandler retryingWebhookHandler;

        @Override
        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return this.formValidation.doCheckCredentialsId(context, credentialsId);
        }

        @Override
        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formValidation.doCheckProjectName(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public FormValidation doCheckRepositoryName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formValidation.doCheckRepositoryName(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public FormValidation doCheckServerId(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formValidation.doCheckServerId(context, serverId);
        }

        @Override
        public FormValidation doCheckSshCredentialsId(@AncestorInPath Item context, @QueryParameter String sshCredentialsId) {
            return this.formValidation.doCheckSshCredentialsId(context, sshCredentialsId);
        }

        @Override
        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            return this.formFill.doFillCredentialsIdItems(context, baseUrl, credentialsId);
        }

        @Override
        @POST
        public ListBoxModel doFillMirrorNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formFill.doFillMirrorNameItems(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @Override
        @POST
        public HttpResponse doFillProjectNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formFill.doFillProjectNameItems(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public HttpResponse doFillRepositoryNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formFill.doFillRepositoryNameItems(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public ListBoxModel doFillServerIdItems(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formFill.doFillServerIdItems(context, serverId);
        }

        @Override
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String sshCredentialsId) {
            return this.formFill.doFillSshCredentialsIdItems(context, baseUrl, sshCredentialsId);
        }

        @Override
        @POST
        public FormValidation doTestConnection(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formValidation.doTestConnection(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        public BitbucketClientFactoryProvider getBitbucketClientFactoryProvider() {
            return this.bitbucketClientFactoryProvider;
        }

        public BitbucketExternalLinkUtils getBitbucketExternalLinkUtils() {
            return this.bitbucketExternalLinkUtils;
        }

        public String getDisplayName() {
            return "Bitbucket server";
        }

        @Override
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return Collections.emptyList();
        }

        @Override
        public List<GitTool> getGitTools() {
            return Collections.emptyList();
        }

        public RetryingWebhookHandler getRetryingWebhookHandler() {
            return this.retryingWebhookHandler;
        }

        @Override
        public boolean getShowGitToolOptions() {
            return false;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Collections.singletonList(new BitbucketBranchDiscoveryTrait());
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            List descriptors = SCMSourceTrait._for((SCMSourceDescriptor)this, BitbucketSCMSourceContext.class, GitSCMBuilder.class);
            NamedArrayList.select((List)descriptors, (String)Messages.bitbucket_scm_trait_type_withinrepository(), (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Selection.class), NamedArrayList.withAnnotation(Discovery.class)}), (boolean)true, result);
            NamedArrayList.select((List)descriptors, (String)Messages.bitbucket_scm_trait_type_additional(), null, (boolean)true, result);
            return result;
        }

        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, new ChangeRequestSCMHeadCategory(Messages._bitbucket_scm_pullrequest_display())};
        }

        BitbucketMirrorHandler createMirrorHandler(BitbucketScmHelper helper) {
            return new BitbucketMirrorHandler(this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials, (client, project, repo) -> helper.getRepository(project, repo));
        }

        BitbucketScmHelper getBitbucketScmHelper(String bitbucketUrl, @CheckForNull Credentials httpCredentials) {
            return new BitbucketScmHelper(bitbucketUrl, this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials.toBitbucketCredentials(httpCredentials));
        }

        Optional<BitbucketServerConfiguration> getConfiguration(@Nullable String serverId) {
            return this.bitbucketPluginConfiguration.getServerById(serverId);
        }
    }
}

