/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMException;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFill;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFillDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidation;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidationDelegate;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BitbucketSCMStep
extends SCMStep {
    private List<BranchSpec> branches;
    private String credentialsId;
    private String sshCredentialsId;
    private String id = UUID.randomUUID().toString();
    private final String projectName;
    private final String repositoryName;
    private String serverId;
    private String serverName;
    private String mirrorName;

    @DataBoundConstructor
    public BitbucketSCMStep(String projectName, String repositoryName) {
        this.branches = Collections.singletonList(new BranchSpec("**"));
        if (StringUtils.isBlank((CharSequence)projectName)) {
            throw new BitbucketSCMException("Error creating the Bitbucket SCM: The project name is blank");
        }
        this.projectName = projectName;
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            throw new BitbucketSCMException("Error creating the Bitbucket SCM: The repository name is blank");
        }
        this.repositoryName = repositoryName;
    }

    @DataBoundSetter
    public void setBranches(List<BranchSpec> branches) {
        this.branches = Objects.requireNonNull(branches, "branches");
    }

    @DataBoundSetter
    public void setCredentialsId(@Nullable String credentialsId) {
        this.credentialsId = StringUtils.stripToNull((String)credentialsId);
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = Objects.requireNonNull(id, "id");
    }

    @DataBoundSetter
    public void setMirrorName(@Nullable String mirrorName) {
        this.mirrorName = StringUtils.stripToNull((String)mirrorName);
    }

    @DataBoundSetter
    public void setServerId(String serverId) {
        this.serverId = Objects.requireNonNull(serverId, "serverId");
    }

    @DataBoundSetter
    public void setServerName(String serverName) {
        this.serverName = Objects.requireNonNull(serverName, "serverName");
    }

    @DataBoundSetter
    public void setSshCredentialsId(@Nullable String sshCredentialsId) {
        this.sshCredentialsId = StringUtils.stripToNull((String)sshCredentialsId);
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Nullable
    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getMirrorName() {
        return this.mirrorName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getServerId() {
        return this.serverId;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    protected SCM createSCM() {
        this.resolveServerId();
        return new BitbucketSCM(this.id, this.branches, this.credentialsId, this.sshCredentialsId, null, null, this.projectName, this.repositoryName, this.serverId, this.mirrorName);
    }

    private void resolveServerId() {
        List<BitbucketServerConfiguration> serverList;
        if (this.serverId != null) {
            return;
        }
        if (this.serverName != null) {
            serverList = ((DescriptorImpl)this.getDescriptor()).getServerListByName(this.serverName);
            if (serverList.isEmpty()) {
                throw new BitbucketSCMException("Error creating Bitbucket SCM: No server configuration matches provided name");
            }
            if (serverList.size() > 1) {
                throw new BitbucketSCMException("Error creating Bitbucket SCM: Multiple server configurations match provided service name. Use serverId to disambiguate");
            }
        } else {
            throw new BitbucketSCMException("Error creating Bitbucket SCM: No server name or ID provided");
        }
        this.serverId = serverList.get(0).getId();
    }

    @Symbol(value={"BitbucketSCMStep"})
    @Extension
    public static class DescriptorImpl
    extends SCMStep.SCMStepDescriptor
    implements BitbucketScmFormValidation,
    BitbucketScmFormFill {
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private BitbucketScmFormFillDelegate formFill;
        @Inject
        private BitbucketScmFormValidationDelegate formValidation;

        @Override
        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return this.formValidation.doCheckCredentialsId(context, credentialsId);
        }

        @Override
        public FormValidation doCheckSshCredentialsId(@AncestorInPath Item context, @QueryParameter String sshCredentialsId) {
            return this.formValidation.doCheckSshCredentialsId(context, sshCredentialsId);
        }

        @Override
        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formValidation.doCheckProjectName(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public FormValidation doCheckRepositoryName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formValidation.doCheckRepositoryName(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public FormValidation doCheckServerId(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formValidation.doCheckServerId(context, serverId);
        }

        @Override
        public FormValidation doTestConnection(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formValidation.doTestConnection(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @Override
        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            return this.formFill.doFillCredentialsIdItems(context, baseUrl, credentialsId);
        }

        @Override
        @POST
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String sshCredentialsId) {
            return this.formFill.doFillSshCredentialsIdItems(context, baseUrl, sshCredentialsId);
        }

        @Override
        @POST
        public HttpResponse doFillProjectNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formFill.doFillProjectNameItems(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public HttpResponse doFillRepositoryNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formFill.doFillRepositoryNameItems(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public ListBoxModel doFillServerIdItems(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formFill.doFillServerIdItems(context, serverId);
        }

        @Override
        public ListBoxModel doFillMirrorNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formFill.doFillMirrorNameItems(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @Override
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return Collections.emptyList();
        }

        public String getFunctionName() {
            return "bbs_checkout";
        }

        @Override
        public List<GitTool> getGitTools() {
            return Collections.emptyList();
        }

        @Override
        public boolean getShowGitToolOptions() {
            return false;
        }

        @VisibleForTesting
        List<BitbucketServerConfiguration> getServerListByName(String serverName) {
            return this.bitbucketPluginConfiguration.getValidServerListByName(serverName);
        }
    }
}

