/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirrorServer;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequest;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequestRef;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRefChange;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRefChangeType;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketBranchSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookTrigger;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookTriggerImpl;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookTriggerRequest;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.AbstractWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.MirrorSynchronizedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestClosedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestFromRefUpdatedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestOpenedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.RefsChangedWebhookEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.triggers.SCMTriggerItem;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Singleton
public class BitbucketWebhookConsumer {
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookConsumer.class.getName());
    @Inject
    private BitbucketPluginConfiguration bitbucketPluginConfiguration;

    void process(AbstractWebhookEvent e) {
        if (e instanceof MirrorSynchronizedWebhookEvent) {
            this.process((MirrorSynchronizedWebhookEvent)e);
        } else if (e instanceof RefsChangedWebhookEvent) {
            this.process((RefsChangedWebhookEvent)e);
        } else if (e instanceof PullRequestWebhookEvent) {
            this.process((PullRequestWebhookEvent)e);
        }
    }

    private void process(RefsChangedWebhookEvent event) {
        BitbucketRepository repository = event.getRepository();
        String webhookEventType = "Refs Changed";
        if (event instanceof MirrorSynchronizedWebhookEvent) {
            webhookEventType = "Mirror Synchronized";
        }
        LOGGER.fine(String.format("Received %s event from repo: %s/%s", webhookEventType, repository.getProject().getKey(), repository.getSlug()));
        Set<BitbucketRefChange> eligibleUpdatedRefs = BitbucketWebhookConsumer.eligibleRefs(event);
        if (!eligibleUpdatedRefs.isEmpty()) {
            RefChangedDetails refChangedDetails = new RefChangedDetails(event);
            try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
                BitbucketWebhookTriggerRequest.Builder requestBuilder = BitbucketWebhookTriggerRequest.builder();
                event.getActor().ifPresent(requestBuilder::actor);
                this.processJobs(event, refChangedDetails, requestBuilder);
                BitbucketSCMHeadEvent.fireNow((SCMHeadEvent)new BitbucketSCMHeadEvent(SCMEvent.Type.UPDATED, event, eligibleUpdatedRefs, event.getRepository().getSlug()));
            }
        }
        HashSet<BitbucketRefChange> deletedRefs = new HashSet<BitbucketRefChange>(event.getChanges());
        deletedRefs.removeAll(eligibleUpdatedRefs);
        if (!deletedRefs.isEmpty()) {
            BitbucketSCMHeadEvent.fireNow((SCMHeadEvent)new BitbucketSCMHeadEvent(SCMEvent.Type.REMOVED, event, deletedRefs, event.getRepository().getSlug()));
        }
    }

    private void process(PullRequestWebhookEvent event) {
        LOGGER.fine("Received pull request event");
        if (event instanceof PullRequestOpenedWebhookEvent || event instanceof PullRequestFromRefUpdatedWebhookEvent) {
            RefChangedDetails refChangedDetails = new RefChangedDetails(event);
            try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
                BitbucketWebhookTriggerRequest.Builder requestBuilder = BitbucketWebhookTriggerRequest.builder();
                event.getActor().ifPresent(requestBuilder::actor);
                this.processJobs(event, refChangedDetails, requestBuilder);
                BitbucketSCMHeadPullRequestEvent.fireNow((SCMHeadEvent)new BitbucketSCMHeadPullRequestEvent(BitbucketWebhookConsumer.getSCMEventType(event), event, event.getPullRequest().getToRef().getRepository().getSlug()));
            }
        } else if (event instanceof PullRequestClosedWebhookEvent) {
            BitbucketSCMHeadPullRequestEvent.fireNow((SCMHeadEvent)new BitbucketSCMHeadPullRequestEvent(SCMEvent.Type.REMOVED, event, event.getPullRequest().getFromRef().getRepository().getSlug()));
        }
    }

    private static Set<BitbucketRefChange> eligibleRefs(RefsChangedWebhookEvent event) {
        return event.getChanges().stream().filter(refChange -> refChange.getType() != BitbucketRefChangeType.DELETE).collect(Collectors.toSet());
    }

    private static SCMEvent.Type getSCMEventType(PullRequestWebhookEvent event) {
        if (event instanceof PullRequestOpenedWebhookEvent) {
            return SCMEvent.Type.CREATED;
        }
        if (event instanceof PullRequestFromRefUpdatedWebhookEvent) {
            return SCMEvent.Type.UPDATED;
        }
        return SCMEvent.Type.REMOVED;
    }

    private static Optional<? extends SCM> getScmFromWorkflowJob(WorkflowJob job) {
        if (job.getDefinition() instanceof CpsScmFlowDefinition) {
            CpsScmFlowDefinition scmFlowDefinition = (CpsScmFlowDefinition)job.getDefinition();
            return Optional.of(scmFlowDefinition.getScm());
        }
        LOGGER.info(String.format("Webhook triggering job with no SCM: %s ", job.getFullDisplayName()));
        return Optional.empty();
    }

    private static Collection<? extends SCM> getScms(ParameterizedJobMixIn.ParameterizedJob<?, ?> job) {
        SCMTriggerItem triggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
        if (triggerItem instanceof WorkflowJob) {
            return BitbucketWebhookConsumer.getScmFromWorkflowJob((WorkflowJob)triggerItem).map(Collections::singleton).orElse(Collections.emptySet());
        }
        if (triggerItem != null) {
            return triggerItem.getSCMs();
        }
        return Collections.emptySet();
    }

    private static boolean hasMatchingRepository(RefChangedDetails refChangedDetails, GitSCM scm) {
        return scm.getRepositories().stream().anyMatch(scmRepo -> BitbucketWebhookConsumer.matchingRepo(refChangedDetails.getCloneLinks(), scmRepo));
    }

    private static boolean matchingRepo(Set<String> cloneLinks, RemoteConfig repo) {
        return repo.getURIs().stream().anyMatch(uri -> {
            String uriStr = uri.toString();
            return cloneLinks.stream().anyMatch(link -> link.equalsIgnoreCase(uriStr));
        });
    }

    private static boolean matchingRepo(BitbucketRepository repository, BitbucketSCMRepository scmRepo) {
        return scmRepo.getProjectKey().equalsIgnoreCase(repository.getProject().getKey()) && scmRepo.getRepositorySlug().equalsIgnoreCase(repository.getSlug());
    }

    private static Optional<TriggerDetails> toTriggerDetails(ParameterizedJobMixIn.ParameterizedJob<?, ?> job) {
        BitbucketWebhookTriggerImpl trigger = BitbucketWebhookConsumer.triggerFrom(job);
        if (trigger != null) {
            return Optional.of(new TriggerDetails(job, trigger));
        }
        return Optional.empty();
    }

    @Nullable
    private static BitbucketWebhookTriggerImpl triggerFrom(ParameterizedJobMixIn.ParameterizedJob<?, ?> job) {
        Map triggers = job.getTriggers();
        for (Trigger candidate : triggers.values()) {
            if (!(candidate instanceof BitbucketWebhookTriggerImpl)) continue;
            return (BitbucketWebhookTriggerImpl)candidate;
        }
        return null;
    }

    private boolean hasMatchingRepository(RefChangedDetails refChangedDetails, ParameterizedJobMixIn.ParameterizedJob<?, ?> job) {
        Collection<? extends SCM> scms = BitbucketWebhookConsumer.getScms(job);
        for (SCM sCM : scms) {
            if (sCM instanceof GitSCM) {
                return BitbucketWebhookConsumer.hasMatchingRepository(refChangedDetails, (GitSCM)sCM);
            }
            if (!(sCM instanceof BitbucketSCM)) continue;
            return this.hasMatchingRepository(refChangedDetails, (BitbucketSCM)sCM);
        }
        return false;
    }

    private boolean hasMatchingRepository(RefChangedDetails refChangedDetails, BitbucketSCM scm) {
        if (refChangedDetails.isMirrorSyncEvent() && !refChangedDetails.getMirrorName().equals(scm.getMirrorName())) {
            return false;
        }
        return this.bitbucketPluginConfiguration.getServerById(scm.getServerId()).map(serverConfig -> {
            String selfLink = refChangedDetails.getRepository().getSelfLink();
            if (StringUtils.isBlank((CharSequence)selfLink) || selfLink.startsWith(serverConfig.getBaseUrl())) {
                return scm.getRepositories().stream().anyMatch(scmRepo -> BitbucketWebhookConsumer.matchingRepo(refChangedDetails.getRepository(), scmRepo));
            }
            LOGGER.info(String.format("Base URL of incoming repository selflink - [%s] and bitbucket server configured URL - [%s] seems to be be different", StringUtils.isBlank((CharSequence)selfLink) ? "unknown" : selfLink, serverConfig.getBaseUrl()));
            return false;
        }).orElse(false);
    }

    private void processJobs(AbstractWebhookEvent event, RefChangedDetails refChangedDetails, BitbucketWebhookTriggerRequest.Builder requestBuilder) {
        Jenkins.get().getAllItems(ParameterizedJobMixIn.ParameterizedJob.class).stream().map(BitbucketWebhookConsumer::toTriggerDetails).filter(Optional::isPresent).map(Optional::get).filter(details -> details.getTrigger().isApplicableForEvent(event)).filter(triggerDetails -> this.hasMatchingRepository(refChangedDetails, triggerDetails.getJob())).peek(triggerDetails -> LOGGER.fine("Triggering " + triggerDetails.getJob().getFullDisplayName())).forEach(triggerDetails -> triggerDetails.getTrigger().trigger(requestBuilder.build()));
    }

    private static final class TriggerDetails {
        private final ParameterizedJobMixIn.ParameterizedJob<?, ?> job;
        private final BitbucketWebhookTrigger trigger;

        private TriggerDetails(ParameterizedJobMixIn.ParameterizedJob<?, ?> job, BitbucketWebhookTrigger trigger) {
            this.job = job;
            this.trigger = trigger;
        }

        public ParameterizedJobMixIn.ParameterizedJob<?, ?> getJob() {
            return this.job;
        }

        public BitbucketWebhookTrigger getTrigger() {
            return this.trigger;
        }
    }

    static final class RefChangedDetails {
        private final Set<String> cloneLinks;
        private final boolean isMirrorSyncEvent;
        private final String mirrorName;
        private final BitbucketRepository repository;

        private RefChangedDetails(RefsChangedWebhookEvent event) {
            this.repository = event.getRepository();
            this.cloneLinks = RefChangedDetails.cloneLinks(this.repository);
            this.mirrorName = "";
            this.isMirrorSyncEvent = false;
        }

        private RefChangedDetails(MirrorSynchronizedWebhookEvent event) {
            this.repository = event.getRepository();
            this.cloneLinks = RefChangedDetails.cloneLinks(this.repository);
            this.mirrorName = event.getMirrorServer().map(BitbucketMirrorServer::getName).orElse("");
            this.isMirrorSyncEvent = true;
        }

        private RefChangedDetails(PullRequestWebhookEvent event) {
            this.repository = event.getPullRequest().getFromRef().getRepository();
            this.cloneLinks = RefChangedDetails.cloneLinks(this.repository);
            this.mirrorName = "";
            this.isMirrorSyncEvent = false;
        }

        public Set<String> getCloneLinks() {
            return this.cloneLinks;
        }

        public String getMirrorName() {
            return this.mirrorName;
        }

        public BitbucketRepository getRepository() {
            return this.repository;
        }

        public boolean isMirrorSyncEvent() {
            return this.isMirrorSyncEvent;
        }

        private static Set<String> cloneLinks(BitbucketRepository repository) {
            return repository.getCloneUrls().stream().map(BitbucketNamedLink::getHref).collect(Collectors.toSet());
        }
    }

    static class BitbucketSCMHeadEvent
    extends SCMHeadEvent<RefsChangedWebhookEvent> {
        private Collection<BitbucketRefChange> effectiveRefs;

        public BitbucketSCMHeadEvent(SCMEvent.Type type, RefsChangedWebhookEvent payload, Collection<BitbucketRefChange> effectiveRefs, String origin) {
            super(type, (Object)payload, origin);
            this.effectiveRefs = effectiveRefs;
        }

        public String getSourceName() {
            return ((RefsChangedWebhookEvent)this.getPayload()).getRepository().getName();
        }

        public Map<SCMHead, SCMRevision> heads(SCMSource source) {
            if (!(source instanceof BitbucketSCMSource)) {
                return Collections.emptyMap();
            }
            BitbucketSCMSource src = (BitbucketSCMSource)source;
            if (!BitbucketWebhookConsumer.matchingRepo(((RefsChangedWebhookEvent)this.getPayload()).getRepository(), src.getBitbucketSCMRepository())) {
                return Collections.emptyMap();
            }
            return this.effectiveRefs.stream().collect(Collectors.toMap(BitbucketBranchSCMHead::new, change -> new BitbucketSCMRevision(new BitbucketBranchSCMHead((BitbucketRefChange)change), change.getToHash())));
        }

        public boolean isMatch(SCMNavigator navigator) {
            return false;
        }

        public boolean isMatch(SCM scm) {
            return false;
        }

        public boolean isMatch(@NonNull SCMSource source) {
            if (!(source instanceof BitbucketSCMSource)) {
                return false;
            }
            BitbucketSCMSource bitbucketSCMSource = (BitbucketSCMSource)source;
            return bitbucketSCMSource.isEventApplicable(this);
        }
    }

    private static class BitbucketSCMHeadPullRequestEvent
    extends SCMHeadEvent<PullRequestWebhookEvent> {
        public BitbucketSCMHeadPullRequestEvent(SCMEvent.Type type, PullRequestWebhookEvent payload, String origin) {
            super(type, (Object)payload, origin);
        }

        public String getSourceName() {
            return ((PullRequestWebhookEvent)this.getPayload()).getPullRequest().getToRef().getRepository().getName();
        }

        public Map<SCMHead, SCMRevision> heads(SCMSource source) {
            if (!(source instanceof BitbucketSCMSource)) {
                return Collections.emptyMap();
            }
            BitbucketSCMSource src = (BitbucketSCMSource)source;
            if (!BitbucketWebhookConsumer.matchingRepo(((PullRequestWebhookEvent)this.getPayload()).getPullRequest().getToRef().getRepository(), src.getBitbucketSCMRepository())) {
                return Collections.emptyMap();
            }
            BitbucketPullRequest pullRequest = ((PullRequestWebhookEvent)this.getPayload()).getPullRequest();
            BitbucketPullRequestSCMHead prScmHead = new BitbucketPullRequestSCMHead(pullRequest);
            BitbucketPullRequestSCMRevision prScmRevision = new BitbucketPullRequestSCMRevision(prScmHead);
            BitbucketPullRequestRef fromRef = pullRequest.getFromRef();
            BitbucketBranchSCMHead branchSCMHead = new BitbucketBranchSCMHead(fromRef);
            BitbucketSCMRevision branchSCMRevision = new BitbucketSCMRevision(branchSCMHead, branchSCMHead.getLatestCommit());
            HashMap<SCMHead, SCMRevision> scmHeadSCMRevisionMap = new HashMap<SCMHead, SCMRevision>();
            scmHeadSCMRevisionMap.put(prScmHead, (SCMRevision)prScmRevision);
            scmHeadSCMRevisionMap.put(branchSCMHead, branchSCMRevision);
            return scmHeadSCMRevisionMap;
        }

        public boolean isMatch(SCMNavigator navigator) {
            return false;
        }

        public boolean isMatch(SCM scm) {
            return false;
        }
    }
}

