/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.ExtensionPoint;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.PluginLogger;
import java.util.List;
import java.util.Optional;

public abstract class ChecksPublisherFactory
implements ExtensionPoint {
    protected Optional<ChecksPublisher> createPublisher(Run<?, ?> run, TaskListener listener) {
        return Optional.empty();
    }

    protected Optional<ChecksPublisher> createPublisher(Job<?, ?> job, TaskListener listener) {
        return Optional.empty();
    }

    public static ChecksPublisher fromRun(Run<?, ?> run, TaskListener listener) {
        return ChecksPublisherFactory.fromRun(run, listener, new JenkinsFacade());
    }

    public static ChecksPublisher fromJob(Job<?, ?> job, TaskListener listener) {
        return ChecksPublisherFactory.fromJob(job, listener, new JenkinsFacade());
    }

    @VisibleForTesting
    static ChecksPublisher fromRun(Run<?, ?> run, TaskListener listener, JenkinsFacade jenkinsFacade) {
        return ChecksPublisherFactory.findAllPublisherFactories(jenkinsFacade).stream().map(factory -> factory.createPublisher(run, listener)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(new ChecksPublisher.NullChecksPublisher(ChecksPublisherFactory.createLogger(listener)));
    }

    @VisibleForTesting
    static ChecksPublisher fromJob(Job<?, ?> job, TaskListener listener, JenkinsFacade jenkinsFacade) {
        return ChecksPublisherFactory.findAllPublisherFactories(jenkinsFacade).stream().map(factory -> factory.createPublisher(job, listener)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(new ChecksPublisher.NullChecksPublisher(ChecksPublisherFactory.createLogger(listener)));
    }

    private static List<ChecksPublisherFactory> findAllPublisherFactories(JenkinsFacade jenkinsFacade) {
        return jenkinsFacade.getExtensionsFor(ChecksPublisherFactory.class);
    }

    private static PluginLogger createLogger(TaskListener listener) {
        return new PluginLogger(listener.getLogger(), "Checks API");
    }
}

