/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.status;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.QueueListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.checks.status.AbstractStatusChecksProperties;
import io.jenkins.plugins.checks.status.DefaultStatusCheckProperties;
import io.jenkins.plugins.checks.status.FlowExecutionAnalyzer;
import io.jenkins.plugins.checks.status.StatusChecksProperties;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public final class BuildStatusChecksPublisher {
    private static final Logger LOGGER = Logger.getLogger(BuildStatusChecksPublisher.class.getName());
    private static final JenkinsFacade JENKINS = new JenkinsFacade();
    private static final AbstractStatusChecksProperties DEFAULT_PROPERTIES = new DefaultStatusCheckProperties();

    private BuildStatusChecksPublisher() {
    }

    private static void publish(ChecksPublisher publisher, ChecksStatus status, ChecksConclusion conclusion, String name, @CheckForNull ChecksOutput output) {
        ChecksDetails.ChecksDetailsBuilder builder = new ChecksDetails.ChecksDetailsBuilder().withName(name).withStatus(status).withConclusion(conclusion);
        if (output != null) {
            builder.withOutput(output);
        }
        publisher.publish(builder.build());
    }

    @Deprecated
    private static Optional<StatusChecksProperties> findDeprecatedProperties(Job<?, ?> job) {
        return JENKINS.getExtensionsFor(StatusChecksProperties.class).stream().filter(p -> p.isApplicable(job)).findFirst();
    }

    private static AbstractStatusChecksProperties findProperties(Job<?, ?> job) {
        return JENKINS.getExtensionsFor(AbstractStatusChecksProperties.class).stream().filter(p -> p.isApplicable(job)).findFirst().orElse(DEFAULT_PROPERTIES);
    }

    static Optional<String> getChecksName(Run<?, ?> run) {
        return BuildStatusChecksPublisher.getChecksName(run.getParent());
    }

    static Optional<String> getChecksName(Job<?, ?> job) {
        return Stream.of(BuildStatusChecksPublisher.findDeprecatedProperties(job).filter(p -> !p.isSkip(job)).map(p -> p.getName(job)), Optional.of(BuildStatusChecksPublisher.findProperties(job)).filter(p -> !p.isSkipped(job)).map(p -> p.getName(job))).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @CheckForNull
    static ChecksOutput getOutput(Run run) {
        FlowExecution execution;
        if (run instanceof WorkflowRun && (execution = ((WorkflowRun)run).getExecution()) != null) {
            return BuildStatusChecksPublisher.getOutput(run, execution);
        }
        return null;
    }

    static ChecksOutput getOutput(Run run, FlowExecution execution) {
        return new FlowExecutionAnalyzer(run, execution).extractOutput();
    }

    @Extension
    public static class ChecksGraphListener
    implements GraphListener {
        public void onNewHead(FlowNode node) {
            Run run;
            if (node.getAction(LabelAction.class) == null) {
                return;
            }
            try {
                run = (Run)node.getExecution().getOwner().getExecutable();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to find Run from flow node.", e);
                return;
            }
            BuildStatusChecksPublisher.getChecksName(run).ifPresent(checksName -> BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, TaskListener.NULL), ChecksStatus.IN_PROGRESS, ChecksConclusion.NONE, checksName, BuildStatusChecksPublisher.getOutput(run, node.getExecution())));
        }
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run run, @CheckForNull TaskListener listener) {
            BuildStatusChecksPublisher.getChecksName(run).ifPresent(checksName -> BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, listener), ChecksStatus.COMPLETED, this.extractConclusion(run), checksName, BuildStatusChecksPublisher.getOutput(run)));
        }

        private ChecksConclusion extractConclusion(Run<?, ?> run) {
            Result result = run.getResult();
            if (result == null) {
                throw new IllegalStateException("No result when the run completes, run: " + run.toString());
            }
            Job job = run.getParent();
            if (result.isBetterOrEqualTo(Result.SUCCESS)) {
                return ChecksConclusion.SUCCESS;
            }
            if (result.isBetterOrEqualTo(Result.UNSTABLE) && BuildStatusChecksPublisher.findProperties(job).isUnstableBuildNeutral(job)) {
                return ChecksConclusion.NEUTRAL;
            }
            if (result.isBetterOrEqualTo(Result.FAILURE)) {
                return ChecksConclusion.FAILURE;
            }
            if (result.isBetterOrEqualTo(Result.NOT_BUILT)) {
                return ChecksConclusion.SKIPPED;
            }
            if (result.isBetterOrEqualTo(Result.ABORTED)) {
                return ChecksConclusion.CANCELED;
            }
            throw new IllegalStateException("Unsupported run result: " + result);
        }
    }

    @Extension
    public static class JobCheckoutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> run, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
            BuildStatusChecksPublisher.getChecksName(run).ifPresent(checksName -> BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromRun(run, listener), ChecksStatus.IN_PROGRESS, ChecksConclusion.NONE, checksName, null));
        }
    }

    @Extension
    public static class JobScheduledListener
    extends QueueListener {
        public void onEnterWaiting(Queue.WaitingItem wi) {
            if (!(wi.task instanceof Job)) {
                return;
            }
            Job job = (Job)wi.task;
            BuildStatusChecksPublisher.getChecksName(job).ifPresent(checksName -> BuildStatusChecksPublisher.publish(ChecksPublisherFactory.fromJob(job, TaskListener.NULL), ChecksStatus.QUEUED, ChecksConclusion.NONE, checksName, null));
        }
    }
}

