/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.jenkinsci.plugins.custombuildproperties.CustomBuildPropertiesAction;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class SetCustomBuildPropertyStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(SetCustomBuildPropertyStep.class.getName());
    private final String key;
    private final Object value;
    private boolean onlySetIfAbsent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runLogic(String key, Object value, boolean onlySetIfAbsent, Run<?, ?> run) throws Exception {
        Run<?, ?> run2 = run;
        synchronized (run2) {
            CustomBuildPropertiesAction action;
            CustomBuildPropertiesAction actionMayBeNull = (CustomBuildPropertiesAction)run.getAction(CustomBuildPropertiesAction.class);
            if (actionMayBeNull != null) {
                action = actionMayBeNull;
            } else {
                action = new CustomBuildPropertiesAction();
                run.addAction((Action)action);
            }
            if (onlySetIfAbsent) {
                action.setPropertyIfAbsent(key, value);
            } else {
                action.setProperty(key, value);
            }
            run.save();
        }
    }

    @DataBoundConstructor
    public SetCustomBuildPropertyStep(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isOnlySetIfAbsent() {
        return this.onlySetIfAbsent;
    }

    @DataBoundSetter
    public void setOnlySetIfAbsent(boolean onlySetIfAbsent) {
        this.onlySetIfAbsent = onlySetIfAbsent;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final Object value;
        private final boolean onlySetIfAbsent;

        public Execution(SetCustomBuildPropertyStep step, StepContext context) {
            super(context);
            this.key = step.getKey();
            this.value = step.getValue();
            this.onlySetIfAbsent = step.isOnlySetIfAbsent();
        }

        protected Void run() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            SetCustomBuildPropertyStep.runLogic(this.key, this.value, this.onlySetIfAbsent, run);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Set custom build property";
        }

        public String getFunctionName() {
            return "setCustomBuildProperty";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }
}

