/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties;

import hudson.Extension;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.util.Timer;
import org.jenkinsci.plugins.custombuildproperties.CustomBuildPropertiesAction;
import org.jenkinsci.plugins.custombuildproperties.CustomBuildPropertiesListener;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class WaitForCustomBuildPropertiesStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(WaitForCustomBuildPropertiesStep.class.getName());
    private final List<String> keys;
    private final int timeoutTime;
    private TimeUnit timeoutUnit = TimeUnit.MINUTES;

    @DataBoundConstructor
    public WaitForCustomBuildPropertiesStep(List<String> keys, int timeoutTime) {
        this.keys = new ArrayList<String>(keys);
        this.timeoutTime = timeoutTime;
    }

    public int getTimeoutTime() {
        return this.timeoutTime;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    @DataBoundSetter
    public void setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private List<String> keys;
        private long timeoutTimeMillis;
        private boolean alreadyCompleted;
        private volatile transient CustomBuildPropertiesListener listener;
        private volatile transient ScheduledFuture<?> task;
        private volatile transient ScheduledFuture<?> timeoutTask;

        public Execution(WaitForCustomBuildPropertiesStep step, StepContext context) {
            super(context);
            this.keys = step.getKeys();
            this.timeoutTimeMillis = step.getTimeoutUnit().toMillis(step.getTimeoutTime());
        }

        public boolean start() {
            return this.init();
        }

        public void onResume() {
            this.init();
        }

        public void stop(@Nonnull Throwable cause) {
            this.complete();
        }

        private boolean init() {
            if (!this.check()) {
                this.scheduleTimeout();
                this.installChangeEventListener();
                this.scheduleCheck();
                return false;
            }
            return true;
        }

        private void scheduleTimeout() {
            if (this.timeoutTimeMillis > 0L) {
                this.timeoutTask = Timer.get().schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (alreadyCompleted) {
                                return;
                            }
                            this.getContext().onFailure((Throwable)new RuntimeException("Timeout"));
                            this.complete();
                        }
                    }
                }, this.timeoutTimeMillis, TimeUnit.MILLISECONDS);
            }
        }

        private void installChangeEventListener() {
            Run relevantRun;
            try {
                relevantRun = (Run)this.getContext().get(Run.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.listener = new CustomBuildPropertiesListener(){

                @Override
                public void onCustomBuildPropertyChanged(Run run, String key, Object oldValue, Object newValue) {
                    if (run == relevantRun && keys.contains(key)) {
                        this.check();
                    }
                }
            };
            CustomBuildPropertiesListener.all().add((Object)this.listener);
        }

        private void scheduleCheck() {
            this.task = Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    if (!this.check()) {
                        this.scheduleCheck();
                    }
                }
            }, 10L, TimeUnit.MINUTES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean check() {
            Execution execution = this;
            synchronized (execution) {
                boolean exists;
                if (this.alreadyCompleted) {
                    return true;
                }
                try {
                    exists = this.customBuildPropertiesExists();
                }
                catch (Exception e) {
                    this.getContext().onFailure((Throwable)e);
                    this.complete();
                    return true;
                }
                if (exists) {
                    this.getContext().onSuccess(null);
                    this.complete();
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete() {
            Execution execution = this;
            synchronized (execution) {
                if (!this.alreadyCompleted) {
                    this.alreadyCompleted = true;
                    if (this.listener != null) {
                        CustomBuildPropertiesListener.all().remove((Object)this.listener);
                    }
                    if (this.task != null) {
                        this.task.cancel(false);
                    }
                    if (this.timeoutTask != null) {
                        this.timeoutTask.cancel(false);
                    }
                }
            }
        }

        private boolean customBuildPropertiesExists() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            CustomBuildPropertiesAction action = (CustomBuildPropertiesAction)run.getAction(CustomBuildPropertiesAction.class);
            if (action == null) {
                return false;
            }
            for (String key : this.keys) {
                if (action.containsProperty(key)) continue;
                return false;
            }
            return true;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Wait until specified custom build properties are set";
        }

        public String getFunctionName() {
            return "waitForCustomBuildProperties";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }
}

