/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties.table;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.FastDateFormat;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTableCell;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTableHeader;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTableRow;

public class CbpTable {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss EEE");
    private final Map<String, Map<String, Object>> rawData = new TreeMap<String, Map<String, Object>>();
    private final Set<String> rawColumns = new TreeSet<String>();
    private Pattern pattern;
    private String title;
    private List<CbpTableHeader> headers = new ArrayList<CbpTableHeader>();
    private List<CbpTableRow> rows = new ArrayList<CbpTableRow>();

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CbpTableHeader createHeader() {
        CbpTableHeader header = new CbpTableHeader();
        this.headers.add(header);
        return header;
    }

    public CbpTableRow createRow() {
        CbpTableRow row = new CbpTableRow();
        this.rows.add(row);
        return row;
    }

    public List<CbpTableHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<CbpTableRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public void addRawData(String rowName, String columnName, Object value) {
        if (!this.rawData.containsKey(rowName)) {
            this.rawData.put(rowName, new HashMap());
        }
        this.rawData.get(rowName).put(columnName, value);
        this.rawColumns.add(columnName);
    }

    public void processRaw() {
        this.pattern = null;
        for (String string : this.rawColumns) {
            CbpTableHeader header = this.createHeader();
            header.setTitle(string);
        }
        for (Map.Entry entry : this.rawData.entrySet()) {
            String rowName = (String)entry.getKey();
            Map rawCells = (Map)entry.getValue();
            CbpTableRow row = this.createRow();
            row.setTitle(rowName);
            for (String columnName : this.rawColumns) {
                CbpTableCell cell = row.createCell();
                cell.setValue(this.rawFormat(rawCells.get(columnName)));
            }
        }
        this.rawData.clear();
        this.rawColumns.clear();
    }

    private String rawFormat(Object value) {
        if (value instanceof Date || value instanceof Calendar) {
            return DATE_FORMAT.format(value);
        }
        return value == null ? "" : value.toString();
    }
}

