/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.markup.RawHtmlMarkupFormatter;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.User;
import io.jenkins.plugins.customizable_header.UserHeader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SystemMessage
extends AbstractDescribableImpl<SystemMessage> {
    public static final DateTimeFormatter DATE_OUTPUT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter DATE_INPUT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-M-d H:m");
    private final String message;
    private transient String color;
    private SystemMessageColor level;
    private LocalDateTime expireDate;
    private String uid;

    @DataBoundConstructor
    public SystemMessage(String message, SystemMessageColor level, String uid) {
        this.message = Util.fixEmptyAndTrim((String)message);
        this.level = level;
        if (Util.fixEmptyAndTrim((String)uid) == null) {
            uid = UUID.randomUUID().toString();
        }
        this.uid = uid;
    }

    @DataBoundSetter
    public void setExpireDate(String expireDate) {
        if (Util.fixEmptyAndTrim((String)expireDate) != null) {
            this.expireDate = LocalDateTime.parse(expireDate, DATE_INPUT_FORMATTER);
        }
    }

    public String getUid() {
        return this.uid;
    }

    public String getExpireDate() {
        if (this.expireDate != null) {
            return this.expireDate.format(DATE_OUTPUT_FORMATTER);
        }
        return null;
    }

    public boolean isDismissed() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null) {
            return userHeader.getDismissedMessages().contains(this.uid);
        }
        return false;
    }

    public boolean isExpired() {
        if (this.expireDate != null) {
            LocalDateTime now = LocalDateTime.now();
            return this.expireDate.isBefore(now);
        }
        return false;
    }

    @DataBoundSetter
    @Deprecated
    public void setColor(String color) {
        if (color != null) {
            if (color.equals("lightyellow")) {
                this.level = SystemMessageColor.info;
            }
            if (color.equals("red")) {
                this.level = SystemMessageColor.danger;
            }
            if (color.equals("orange")) {
                this.level = SystemMessageColor.warning;
            }
        }
    }

    public Object readResolve() {
        this.setColor(this.color);
        this.color = null;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public SystemMessageColor getLevel() {
        return this.level;
    }

    public String getEscapedMessage() {
        if (this.message == null) {
            return "";
        }
        if (this.isExpired()) {
            return "";
        }
        StringWriter writer = new StringWriter();
        try {
            RawHtmlMarkupFormatter.INSTANCE.translate(this.message, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Deprecated
    public String getColor() {
        return this.color;
    }

    public static enum SystemMessageColor {
        info,
        warning,
        danger,
        success;

    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SystemMessage> {
        @NonNull
        public String getDisplayName() {
            return "System Message";
        }

        public String getMinDate() {
            ZonedDateTime now = ZonedDateTime.now();
            return now.format(DATE_OUTPUT_FORMATTER);
        }
    }
}

