/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header.headers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import io.jenkins.plugins.customizable_header.headers.HeaderDescriptor;
import io.jenkins.plugins.customizable_header.headers.HeaderSelector;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ContextSelector
extends HeaderSelector {
    private static final Logger LOGGER = Logger.getLogger(ContextSelector.class.getName());
    private boolean showJobWeather;
    private boolean showFolderWeather;
    private String symbolMappingFile;
    private transient Properties customMapping;
    private transient long lastModified;
    private transient String mappingFile;

    @DataBoundConstructor
    public ContextSelector(boolean showJobWeather, boolean showFolderWeather) {
        this.showJobWeather = showJobWeather;
        this.showFolderWeather = showFolderWeather;
    }

    public boolean isShowJobWeather() {
        return this.showJobWeather;
    }

    public boolean isShowFolderWeather() {
        return this.showFolderWeather;
    }

    @DataBoundSetter
    public void setSymbolMappingFile(String symbolMappingFile) {
        this.symbolMappingFile = symbolMappingFile;
        this.lastModified = 0L;
    }

    public String getSymbolMappingFile() {
        return this.symbolMappingFile;
    }

    private void updateMappingFile() {
        if (Util.fixEmptyAndTrim((String)this.symbolMappingFile) != null) {
            File file = new File(this.symbolMappingFile);
            if (!file.isAbsolute()) {
                file = new File(Jenkins.get().getRootDir(), this.symbolMappingFile);
            }
            this.mappingFile = file.isFile() ? file.getAbsolutePath() : null;
        } else {
            this.mappingFile = null;
        }
        this.lastModified = -1L;
    }

    @Restricted(value={NoExternalUse.class})
    public Properties getSymbolMapping() {
        File file;
        if (this.customMapping == null) {
            this.customMapping = new Properties();
        }
        if (this.lastModified == 0L) {
            this.updateMappingFile();
        }
        if (this.mappingFile != null && (file = new File(this.mappingFile)).lastModified() != this.lastModified) {
            this.lastModified = file.lastModified();
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                this.customMapping.clear();
                this.customMapping.load(reader);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read custom mapping.", e);
            }
        }
        return this.customMapping;
    }

    @Extension
    @Symbol(value={"context"})
    public static class DescriptorImpl
    extends HeaderDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Context Aware";
        }
    }
}

