/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.darktheme;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.thememanager.Theme;
import io.jenkins.plugins.thememanager.ThemeManagerFactory;
import io.jenkins.plugins.thememanager.ThemeManagerFactoryDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DarkThemeManagerFactory
extends ThemeManagerFactory {
    public static final String THEME_CSS = "theme.css";
    public static final String THEME_URL_NAME = "theme-dark";
    public static final String ACE_EDITOR_THEME = "tomorrow_night";
    public static final String PRISM_THEME = "tomorrow";
    public static final String BOOTSTRAP_THEME = "dark";
    public static final String ENTRA_ID_THEME = "dark";

    @DataBoundConstructor
    public DarkThemeManagerFactory() {
    }

    public Theme getTheme() {
        return Theme.builder().withCssUrl(this.getCssUrl()).withProperty("ace-editor", "theme", ACE_EDITOR_THEME).withProperty("entra-id", "theme", "dark").withProperty("prism-api", "theme", PRISM_THEME).withProperty("bootstrap", "theme", "dark").build();
    }

    @Extension
    @Symbol(value={"dark"})
    public static class DarkThemeManagerFactoryDescriptor
    extends ThemeManagerFactoryDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Dark";
        }

        @NonNull
        public String getThemeId() {
            return "dark";
        }

        public String getThemeKey() {
            return "dark";
        }

        public boolean isNamespaced() {
            return true;
        }
    }
}

