/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.darktheme;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public class DarkThemeRootAction
implements UnprotectedRootAction {
    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "theme-dark";
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, URISyntaxException, ServletException {
        String cssFile = req.getRestOfPath();
        if (cssFile.startsWith("/")) {
            cssFile = cssFile.substring(1);
        }
        if (!"theme.css".equals(cssFile) && !"theme.css.map".equals(cssFile)) {
            rsp.sendError(404);
            return;
        }
        Plugin plugin = Jenkins.get().getPlugin("dark-theme");
        if (plugin == null) {
            rsp.sendError(404);
            return;
        }
        plugin.doDynamic(req, rsp);
    }
}

