/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import hudson.model.Run;
import io.jenkins.plugins.echarts.ActionSelector;
import io.jenkins.plugins.util.BuildAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class GenericBuildActionIterator<A extends BuildAction<?>, R>
implements Iterator<BuildResult<R>> {
    private final ActionSelector<A> actionSelector;
    private Optional<A> latestAction;
    private final Function<A, R> function;

    GenericBuildActionIterator(Class<A> actionType, Optional<A> latestAction, Predicate<A> predicate, Function<A, R> function) {
        this.latestAction = latestAction;
        this.function = function;
        this.actionSelector = new ActionSelector<A>(actionType, predicate);
    }

    @Override
    public boolean hasNext() {
        return this.latestAction.isPresent();
    }

    @Override
    public BuildResult<R> next() {
        if (this.latestAction.isEmpty()) {
            throw new NoSuchElementException("There is no action available anymore. Use hasNext() before calling next().");
        }
        BuildAction buildAction = (BuildAction)this.latestAction.get();
        Run run = buildAction.getOwner();
        this.latestAction = this.actionSelector.apply(run.getPreviousBuild());
        int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
        Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
        return new BuildResult<R>(build, this.function.apply(buildAction));
    }

    public static class BuildActionIterable<A extends BuildAction<?>, R>
    implements Iterable<BuildResult<R>> {
        private final Class<A> actionType;
        private final Optional<A> latestAction;
        private final Predicate<A> filter;
        private final Function<A, R> function;

        public BuildActionIterable(Class<A> actionType, Optional<A> latestAction, Predicate<A> filter, Function<A, R> function) {
            this.actionType = actionType;
            this.latestAction = latestAction;
            this.filter = filter;
            this.function = function;
        }

        @Override
        public Iterator<BuildResult<R>> iterator() {
            return new GenericBuildActionIterator<A, R>(this.actionType, this.latestAction, this.filter, this.function);
        }
    }
}

