/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.util.VisibleForTesting;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.Temporal;

public final class TimeFacade {
    private static TimeFacade instance = new TimeFacade();

    public static TimeFacade getInstance() {
        return instance;
    }

    @VisibleForTesting
    public static void reset() {
        TimeFacade.setInstance(new TimeFacade());
    }

    @VisibleForTesting
    public static void setInstance(TimeFacade stubFacade) {
        instance = stubFacade;
    }

    private TimeFacade() {
    }

    public Temporal getToday() {
        return LocalDate.now();
    }

    public LocalDate getBuildDate(Build build) {
        return Instant.ofEpochSecond(build.getBuildTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

