/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.TimeFacade;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;

public class ResultTime {
    public boolean isResultTooOld(ChartModelConfiguration configuration, BuildResult<?> analysisRun) {
        return configuration.isDayCountDefined() && this.computeDayDelta(analysisRun) > (long)configuration.getDayCount();
    }

    private long computeDayDelta(BuildResult<?> result) {
        return Math.abs(ChronoUnit.DAYS.between(this.toLocalDate(result.getBuild().getBuildTime()), TimeFacade.getInstance().getToday()));
    }

    private LocalDate toLocalDate(long timeInSeconds) {
        return Instant.ofEpochSecond(timeInSeconds).atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

