/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.hm.hafner.util.Generated;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TreeNode {
    private String name;
    private double value;
    @JsonIgnore
    private Map<String, TreeNode> childrenMap = new HashMap<String, TreeNode>();

    public TreeNode(String name) {
        this(name, 0.0);
    }

    public TreeNode(String name, double value) {
        this.value = value;
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    private void addValue(double amount) {
        this.value += amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public Map<String, TreeNode> getChildrenMap() {
        return this.childrenMap;
    }

    public List<TreeNode> getChildren() {
        return new ArrayList<TreeNode>(this.childrenMap.values());
    }

    public void collapsePackage() {
        while (this.getChildren().size() == 1) {
            TreeNode singleChild = this.getChildrenMap().values().iterator().next();
            if (this.name.isEmpty()) {
                this.setName(singleChild.getName());
            } else {
                this.setName(this.name + "." + singleChild.getName());
            }
            this.childrenMap = singleChild.getChildrenMap();
        }
    }

    public void insertNode(TreeNode node) {
        ArrayDeque<String> packageLevels = new ArrayDeque<String>(Arrays.asList(node.getName().split("\\.")));
        this.insertNode(node, packageLevels);
    }

    private void insertNode(TreeNode node, Deque<String> levels) {
        String nextLevelName = levels.pop();
        this.addValue(node.getValue());
        if (levels.isEmpty()) {
            node.setName(nextLevelName);
            this.childrenMap.put(nextLevelName, node);
        } else {
            this.updateChildren(node, levels, nextLevelName);
        }
    }

    private void updateChildren(TreeNode node, Deque<String> levels, String nextLevelName) {
        this.childrenMap.putIfAbsent(nextLevelName, new TreeNode(nextLevelName));
        this.childrenMap.get(nextLevelName).insertNode(node, levels);
    }

    public String toString() {
        return "TreeNode '%s' (%s)".formatted(this.name, this.value);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNode treeNode = (TreeNode)o;
        return Double.compare(this.value, treeNode.value) == 0 && Objects.equals(this.name, treeNode.name) && Objects.equals(this.childrenMap, treeNode.childrenMap);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.name, this.value, this.childrenMap);
    }
}

