/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts.line;

import edu.hm.hafner.echarts.AreaStyle;
import edu.hm.hafner.echarts.Emphasis;
import edu.hm.hafner.echarts.ItemStyle;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;

public class LineSeries {
    private final String name;
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"})
    private final String type = "line";
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"})
    private final String symbol = "circle";
    private final List<Double> data = new ArrayList<Double>();
    private final ItemStyle itemStyle;
    private final StackedMode stackedMode;
    private final FilledMode filledMode;

    public LineSeries(String name, String color, StackedMode stackedMode, FilledMode filledMode) {
        this.name = name;
        this.itemStyle = new ItemStyle(color);
        this.stackedMode = stackedMode;
        this.filledMode = filledMode;
    }

    public LineSeries(String name, String color, StackedMode stackedMode, FilledMode filledMode, List<Double> values) {
        this(name, color, stackedMode, filledMode);
        this.addAll(values);
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return "circle";
    }

    public String getStack() {
        return this.stackedMode == StackedMode.STACKED ? "stacked" : "";
    }

    public String getType() {
        return "line";
    }

    @CheckForNull
    public AreaStyle getAreaStyle() {
        return this.filledMode == FilledMode.FILLED ? new AreaStyle() : null;
    }

    public List<Double> getData() {
        return this.data;
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    @CheckForNull
    public Emphasis getEmphasis() {
        return this.filledMode == FilledMode.LINES ? new Emphasis() : null;
    }

    public void add(double value) {
        this.data.add(0, value);
    }

    public final void addAll(List<Double> values) {
        this.data.addAll(values);
    }

    public static enum StackedMode {
        STACKED,
        SEPARATE_LINES;

    }

    public static enum FilledMode {
        FILLED,
        LINES;

    }
}

