/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.libs.LibraryAdder;
import org.jenkinsci.plugins.workflow.libs.Messages;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ResourceStep
extends Step {
    private final String resource;
    private String encoding;

    @DataBoundConstructor
    public ResourceStep(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    @CheckForNull
    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private final transient ResourceStep step;

        public Execution(ResourceStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            String resource = this.step.resource;
            Map<String, String> contents = LibraryAdder.findResources((CpsFlowExecution)this.getContext().get(FlowExecution.class), resource, this.step.encoding);
            if (contents.isEmpty()) {
                throw new AbortException(Messages.ResourceStep_no_such_library_resource_could_be_found_(resource));
            }
            if (contents.size() == 1) {
                return contents.values().iterator().next();
            }
            throw new AbortException(Messages.ResourceStep_library_resource_ambiguous_among_librari(resource, contents.keySet()));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Load a resource file from a library";
        }

        public String getFunctionName() {
            return "libraryResource";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(FlowExecution.class);
        }
    }
}

