/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.XmlFile;
import hudson.util.XStream2;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

@SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"}, justification="Filename is always safe")
public abstract class AbstractXmlStream<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractXmlStream.class.getName());
    private final Class<T> type;

    protected AbstractXmlStream(Class<T> type) {
        this.type = type;
    }

    protected abstract T createDefaultValue();

    private XStream2 createStream() {
        XStream2 xStream2 = new XStream2();
        xStream2.registerConverter((Converter)new TreeStringConverter());
        this.configureXStream(xStream2);
        return xStream2;
    }

    protected void configureXStream(XStream2 xStream) {
    }

    public T read(Path file) {
        return this.readXml(this.createFile(file), this.createDefaultValue());
    }

    public void write(Path file, T entity) {
        try {
            this.createFile(file).write(entity);
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Failed to write entity to file " + file, exception);
        }
    }

    private XmlFile createFile(Path file) {
        return new XmlFile((XStream)this.createStream(), file.toFile());
    }

    private T readXml(XmlFile dataFile, T defaultValue) {
        try {
            Object restored = dataFile.read();
            if (this.type.isInstance(restored)) {
                LOGGER.log(Level.FINE, "Loaded data file " + dataFile);
                return this.type.cast(restored);
            }
            LOGGER.log(Level.SEVERE, "Failed to load " + dataFile + ", wrong type: " + restored);
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Failed to load " + dataFile, exception);
        }
        return defaultValue;
    }

    private static final class TreeStringConverter
    implements Converter {
        private TreeStringConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.setValue(source == null ? null : source.toString());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            TreeStringBuilder builder = (TreeStringBuilder)context.get(TreeStringBuilder.class);
            if (builder == null) {
                builder = new TreeStringBuilder();
                context.put(TreeStringBuilder.class, (Object)builder);
                context.addCompletionCallback(builder::dedup, 0);
            }
            return builder.intern(reader.getValue());
        }

        public boolean canConvert(Class type) {
            return type == TreeString.class;
        }
    }
}

