/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.FilteredLog;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.prism.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.jvnet.localizer.LocaleProvider;
import org.jvnet.localizer.Localizable;

public enum SourceCodeRetention {
    NEVER(new CleanupOldBuilds(), Messages._SourceCodeRetention_NEVER()),
    LAST_BUILD(new CleanupOldBuilds(), Messages._SourceCodeRetention_LAST_BUILD()),
    EVERY_BUILD(new Cleanup(), Messages._SourceCodeRetention_EVERY_BUILD()),
    MODIFIED(new Cleanup(), Messages._SourceCodeRetention_MODIFIED());

    private final Cleanup cleanupStrategy;
    private final Localizable localizable;

    public static ListBoxModel fillItems() {
        ListBoxModel items = new ListBoxModel();
        for (SourceCodeRetention retention : SourceCodeRetention.values()) {
            items.add(retention.getDisplayName(), retention.name());
        }
        return items;
    }

    private SourceCodeRetention(Cleanup cleanupStrategy, Localizable localizable) {
        this.cleanupStrategy = cleanupStrategy;
        this.localizable = localizable;
    }

    public String getDisplayName() {
        return this.localizable.toString(LocaleProvider.getLocale());
    }

    public void cleanup(Run<?, ?> build, String directory, FilteredLog log) {
        this.cleanupStrategy.clean(build, directory, log);
    }

    static class Cleanup {
        Cleanup() {
        }

        void clean(Run<?, ?> build, String directory, FilteredLog log) {
            log.logInfo("Skipping cleaning of source code files in old builds");
        }
    }

    static class CleanupOldBuilds
    extends Cleanup {
        CleanupOldBuilds() {
        }

        @Override
        void clean(Run<?, ?> currentBuild, String directory, FilteredLog log) {
            for (Run build = currentBuild.getPreviousCompletedBuild(); build != null; build = build.getPreviousCompletedBuild()) {
                Path buildDir = build.getRootDir().toPath();
                Path sourcesFolder = buildDir.resolve(directory);
                if (!Files.exists(sourcesFolder, new LinkOption[0])) continue;
                try {
                    FileUtils.deleteDirectory((File)sourcesFolder.toFile());
                    log.logInfo("Deleting source code files of build " + build.getDisplayName());
                    continue;
                }
                catch (IOException exception) {
                    log.logException((Exception)exception, "Could not delete source code files of build " + build.getDisplayName(), new Object[0]);
                }
            }
        }
    }
}

