/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch.extended;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.Serializable;
import java.util.Collection;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.extended.Messages;
import org.jenkinsci.plugins.workflow.multibranch.extended.scm.ExtendedSCMBinder;
import org.jenkinsci.plugins.workflow.multibranch.extended.scm.LocalMarkerSCMSourceCriteria;
import org.jenkinsci.plugins.workflow.multibranch.extended.scm.SCMFilter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RemoteJenkinsFileWorkflowBranchProjectFactory
extends WorkflowBranchProjectFactory {
    private static final String DEFAULT_JENKINS_FILE = "Jenkinsfile";
    private String localMarker = "";
    private String remoteJenkinsFile = "";
    private SCM remoteJenkinsFileSCM;
    private Boolean matchBranches = false;
    private String scmSourceBranchName = "master";
    private String fallbackBranch = "master";
    private Boolean lookupInParameters = false;

    public Boolean getLookupInParameters() {
        return this.lookupInParameters;
    }

    @DataBoundSetter
    public void setLookupInParameters(Boolean lookupInParameters) {
        this.lookupInParameters = lookupInParameters;
    }

    @DataBoundSetter
    public void setRemoteJenkinsFile(String remoteJenkinsFile) {
        this.remoteJenkinsFile = StringUtils.isEmpty((String)remoteJenkinsFile) ? DEFAULT_JENKINS_FILE : remoteJenkinsFile;
    }

    @DataBoundSetter
    public void setRemoteJenkinsFileSCM(SCM remoteJenkinsFileSCM) {
        this.remoteJenkinsFileSCM = remoteJenkinsFileSCM;
    }

    @DataBoundConstructor
    public RemoteJenkinsFileWorkflowBranchProjectFactory(String remoteJenkinsFile, String localMarker, SCM remoteJenkinsFileSCM, Boolean matchBranches, String fallbackBranch, Boolean lookupInParameters) {
        this.localMarker = localMarker;
        this.remoteJenkinsFile = remoteJenkinsFile;
        this.remoteJenkinsFileSCM = remoteJenkinsFileSCM;
        this.matchBranches = matchBranches;
        this.fallbackBranch = fallbackBranch;
        this.lookupInParameters = lookupInParameters;
    }

    protected FlowDefinition createDefinition() {
        return new ExtendedSCMBinder(this.remoteJenkinsFile, this.remoteJenkinsFileSCM, this.scmSourceBranchName, this.matchBranches, this.fallbackBranch, this.remoteJenkinsFile, this.lookupInParameters, this.localMarker);
    }

    protected SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        return (SCMSourceCriteria & Serializable)(probe, taskListener) -> {
            if (this.remoteJenkinsFileSCM == null || StringUtils.isEmpty((String)this.remoteJenkinsFile)) {
                return false;
            }
            this.setScmSourceBranchName(probe.name());
            return LocalMarkerSCMSourceCriteria.matches(this.localMarker, probe, taskListener);
        };
    }

    public String getRemoteJenkinsFile() {
        return this.remoteJenkinsFile;
    }

    public SCM getRemoteJenkinsFileSCM() {
        return this.remoteJenkinsFileSCM;
    }

    public String getLocalMarker() {
        return this.localMarker;
    }

    @DataBoundSetter
    public void setMatchBranches(boolean matchBranches) {
        this.matchBranches = matchBranches;
    }

    public boolean getMatchBranches() {
        return this.matchBranches;
    }

    public void setScmSourceBranchName(String scmSourceBranchName) {
        this.scmSourceBranchName = scmSourceBranchName;
    }

    public String getScmSourceBranchName() {
        return this.scmSourceBranchName;
    }

    public String getFallbackBranch() {
        return this.fallbackBranch;
    }

    @DataBoundSetter
    public void setFallbackBranch(String fallbackBranch) {
        this.fallbackBranch = fallbackBranch;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractWorkflowBranchProjectFactory.AbstractWorkflowBranchProjectFactoryDescriptor {
        @NonNull
        public String getDisplayName() {
            return "by " + Messages.ProjectRecognizer_DisplayName();
        }

        public Collection<? extends SCMDescriptor<?>> getApplicableDescriptors() {
            return SCMFilter.filter();
        }
    }
}

