/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch.extended;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.scm.SCM;
import java.io.Serializable;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProjectFactory;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowMultiBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.extended.Messages;
import org.jenkinsci.plugins.workflow.multibranch.extended.RemoteJenkinsFileWorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.extended.scm.LocalMarkerSCMSourceCriteria;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RemoteJenkinsFileWorkflowMultiBranchProjectFactory
extends AbstractWorkflowMultiBranchProjectFactory {
    private static final String DEFAULT_JENKINS_FILE = "Jenkinsfile";
    private String localMarker = "";
    private String remoteJenkinsFile = "";
    private Boolean lookupInParameters = false;
    private Boolean matchBranches = false;
    private String scmSourceBranchName = "master";
    private String fallbackBranch = "master";
    private SCM remoteJenkinsFileSCM;

    private RemoteJenkinsFileWorkflowMultiBranchProjectFactory() {
    }

    public Boolean getLookupInParameters() {
        return this.lookupInParameters;
    }

    @DataBoundSetter
    public void setLookupInParameters(Boolean lookupInParameters) {
        this.lookupInParameters = lookupInParameters;
    }

    @DataBoundSetter
    public void setRemoteJenkinsFile(String remoteJenkinsFile) {
        this.remoteJenkinsFile = StringUtils.isEmpty((String)remoteJenkinsFile) ? DEFAULT_JENKINS_FILE : remoteJenkinsFile;
    }

    @DataBoundSetter
    public void setRemoteJenkinsFileSCM(SCM remoteJenkinsFileSCM) {
        this.remoteJenkinsFileSCM = remoteJenkinsFileSCM;
    }

    @DataBoundSetter
    public void setLocalMarkerForReconize(String localMarkerForRecognize) {
        this.localMarker = localMarkerForRecognize;
    }

    @DataBoundConstructor
    public RemoteJenkinsFileWorkflowMultiBranchProjectFactory(String localMarker, String remoteJenkinsFile, SCM remoteJenkinsFileSCM, Boolean matchBranches, Boolean lookupInParameters) {
        this.localMarker = localMarker;
        this.remoteJenkinsFile = remoteJenkinsFile;
        this.remoteJenkinsFileSCM = remoteJenkinsFileSCM;
        this.matchBranches = matchBranches;
        this.lookupInParameters = lookupInParameters;
    }

    protected SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource source) {
        return (SCMSourceCriteria & Serializable)(probe, taskListener) -> {
            if (this.remoteJenkinsFileSCM == null || StringUtils.isEmpty((String)this.remoteJenkinsFile)) {
                return false;
            }
            this.setScmSourceBranchName(probe.name());
            return LocalMarkerSCMSourceCriteria.matches(this.localMarker, probe, taskListener);
        };
    }

    public String getRemoteJenkinsFile() {
        return this.remoteJenkinsFile;
    }

    public SCM getRemoteJenkinsFileSCM() {
        return this.remoteJenkinsFileSCM;
    }

    public String getLocalMarker() {
        return this.localMarker;
    }

    protected void customize(WorkflowMultiBranchProject project) {
        RemoteJenkinsFileWorkflowBranchProjectFactory projectFactory = new RemoteJenkinsFileWorkflowBranchProjectFactory(this.remoteJenkinsFile, this.localMarker, this.remoteJenkinsFileSCM, this.getMatchBranches(), this.fallbackBranch, this.lookupInParameters);
        project.setProjectFactory((BranchProjectFactory)projectFactory);
    }

    @DataBoundSetter
    public void setMatchBranches(boolean matchBranches) {
        this.matchBranches = matchBranches;
    }

    public boolean getMatchBranches() {
        return this.matchBranches;
    }

    public void setScmSourceBranchName(String scmSourceBranchName) {
        this.scmSourceBranchName = scmSourceBranchName;
    }

    public String getScmSourceBranchName() {
        return this.scmSourceBranchName;
    }

    public String getFallbackBranch() {
        return this.fallbackBranch;
    }

    @DataBoundSetter
    public void setFallbackBranch(String fallbackBranch) {
        this.fallbackBranch = fallbackBranch;
    }

    @Extension
    public static class DescriptorImpl
    extends MultiBranchProjectFactoryDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ProjectRecognizer_DisplayName();
        }

        @CheckForNull
        public MultiBranchProjectFactory newInstance() {
            return new RemoteJenkinsFileWorkflowMultiBranchProjectFactory();
        }
    }
}

