/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch.extended.scm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public class ExtendedSCMBinder
extends FlowDefinition {
    private String remoteJenkinsFile = "";
    private String remoteJenkinsFileBranch = "";
    private String originJenkinsFileDefinition = "";
    private String localMarker = "";
    private Boolean lookupInParameters = false;
    private Boolean matchBranches = false;
    private final SCM remoteJenkinsFileSCM;
    private String scmSourceBranchName = "master";
    private String fallbackBranch = "master";
    private final String matchBranchFailMessage;
    private final String matchBranchFallbackMessage;

    public ExtendedSCMBinder(String remoteJenkinsFile, SCM remoteJenkinsFileSCM, String scmSourceBranchName, boolean matchBranches, String fallbackBranch, String originJenkinsFileDefinition, Boolean lookupInParameters, String localMarker) {
        this.remoteJenkinsFile = remoteJenkinsFile;
        this.remoteJenkinsFileSCM = remoteJenkinsFileSCM;
        this.matchBranches = matchBranches;
        this.scmSourceBranchName = scmSourceBranchName;
        this.remoteJenkinsFileBranch = scmSourceBranchName;
        this.fallbackBranch = fallbackBranch;
        this.matchBranchFailMessage = "Failed to checkout for " + this.scmSourceBranchName + " branch for Jenkins File.";
        this.matchBranchFallbackMessage = "Try to checkout " + this.fallbackBranch + " branch for Jenkins File.  ";
        this.originJenkinsFileDefinition = originJenkinsFileDefinition;
        this.lookupInParameters = lookupInParameters;
        this.localMarker = localMarker;
    }

    public FlowExecution create(FlowExecutionOwner handle, TaskListener listener, List<? extends Action> actions) throws Exception {
        block5: {
            if (this.lookupInParameters != null && this.originJenkinsFileDefinition != null && this.lookupInParameters.booleanValue() && this.originJenkinsFileDefinition.startsWith("$")) {
                String jenkinsfileParameterName = this.originJenkinsFileDefinition.replace("$", "").replace("{", "").replace("}", "");
                String newJenkinsFile = "Jenkinsfile";
                for (Action action : actions) {
                    ParametersAction parametersAction;
                    ParameterValue parameterValue;
                    if (!(action instanceof ParametersAction) || (parameterValue = (parametersAction = (ParametersAction)action).getParameter(jenkinsfileParameterName)) == null) continue;
                    newJenkinsFile = String.valueOf(parameterValue.getValue());
                }
                this.remoteJenkinsFile = newJenkinsFile;
            }
            if (this.matchBranches.booleanValue() && this.remoteJenkinsFileSCM instanceof GitSCM) {
                try {
                    this.remoteJenkinsFileBranch = this.scmSourceBranchName;
                    return new CpsScmFlowDefinition((SCM)this.generateSCMWithNewBranch(this.scmSourceBranchName), this.remoteJenkinsFile).create(handle, listener, actions);
                }
                catch (Exception ex) {
                    if (!(ex instanceof AbortException)) break block5;
                    listener.getLogger().println(this.matchBranchFailMessage);
                    listener.getLogger().println(this.matchBranchFallbackMessage);
                    this.remoteJenkinsFileBranch = this.fallbackBranch;
                    return new CpsScmFlowDefinition((SCM)this.generateSCMWithNewBranch(this.fallbackBranch), this.remoteJenkinsFile).create(handle, listener, actions);
                }
            }
        }
        return new CpsScmFlowDefinition(this.remoteJenkinsFileSCM, this.remoteJenkinsFile).create(handle, listener, actions);
    }

    private GitSCM generateSCMWithNewBranch(String branchName) {
        GitSCM configuredGitSCM = (GitSCM)this.remoteJenkinsFileSCM;
        return new GitSCM(configuredGitSCM.getUserRemoteConfigs(), Collections.singletonList(new BranchSpec(branchName)), Boolean.valueOf(configuredGitSCM.isDoGenerateSubmoduleConfigurations()), configuredGitSCM.getSubmoduleCfg(), configuredGitSCM.getBrowser(), configuredGitSCM.getGitTool(), (List)configuredGitSCM.getExtensions());
    }

    public SCM getRemoteJenkinsFileSCM() {
        return this.remoteJenkinsFileSCM;
    }

    public String getRemoteJenkinsFile() {
        return this.remoteJenkinsFile;
    }

    public String getRemoteJenkinsFileBranch() {
        if (this.remoteJenkinsFileBranch == null) {
            return "N/A";
        }
        return this.remoteJenkinsFileBranch;
    }

    public boolean isMatchBranches() {
        return this.matchBranches;
    }

    public String getLocalMarker() {
        if (this.localMarker == null) {
            return "";
        }
        return this.localMarker;
    }

    @Extension
    public static class HideMe
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, @NonNull Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return context instanceof WorkflowJob && ((WorkflowJob)context).getParent() instanceof WorkflowMultiBranchProject;
            }
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Pipeline from Remote Jenkins File Plugin";
        }
    }
}

