/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.yaml.snakeyaml.Yaml;

public class EnvironmentWrapper
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> rootMap;
    private Map<String, String> properties;
    private String[] profiles;

    private void writeObject(ObjectOutputStream out) throws IOException {
        Yaml yaml = new Yaml();
        String output = yaml.dump(this.properties);
        out.writeUTF(output);
        out.writeObject(this.profiles);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String yamlString = in.readUTF();
        Yaml yaml = new Yaml();
        this.properties = (Map)yaml.load(yamlString);
        this.rootMap = this.createNestedMap(this.properties);
        this.profiles = (String[])in.readObject();
    }

    public EnvironmentWrapper(StandardEnvironment environment) {
        this.properties = this.toProperties(environment);
        this.rootMap = this.createNestedMap(this.properties);
        this.profiles = environment.getActiveProfiles();
    }

    @Whitelisted
    public List<String> getProfiles() {
        return ImmutableList.copyOf((Object[])this.profiles);
    }

    public String getProfilesAsString() {
        return String.join((CharSequence)",", this.profiles);
    }

    @Whitelisted
    public Map<String, String> asProperties() {
        return this.properties;
    }

    @Whitelisted
    public String asPropertiesFileContent() {
        Properties javaProperties = new Properties();
        this.properties.forEach((key, value) -> javaProperties.setProperty((String)key, String.valueOf(value)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        javaProperties.store(baos, "With profiles [" + this.getProfilesAsString() + "]");
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rootMap.entrySet();
    }

    private Map<String, String> toProperties(StandardEnvironment environment) {
        LinkedHashMap map = new LinkedHashMap();
        LinkedHashMap<String, Object> combinedMap = new LinkedHashMap<String, Object>();
        ArrayList sources = new ArrayList(environment.getPropertySources().stream().collect(Collectors.toList()));
        Collections.reverse(sources);
        sources.stream().filter(source -> source instanceof OriginTrackedMapPropertySource).forEach((? super T source) -> {
            Map value = (Map)source.getSource();
            for (Map.Entry entry : value.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.contains("[")) {
                    Object val = entry.getValue();
                    if (val instanceof OriginTrackedValue) {
                        val = ((OriginTrackedValue)val).getValue();
                    }
                    combinedMap.put(key, val);
                    continue;
                }
                key = key.substring(0, key.indexOf("["));
                LinkedHashMap filtered = new LinkedHashMap();
                for (Map.Entry innerLoopEntry : value.entrySet()) {
                    String index = (String)innerLoopEntry.getKey();
                    if (!index.startsWith(key + "[")) continue;
                    Object val = innerLoopEntry.getValue();
                    if (val instanceof OriginTrackedValue) {
                        val = ((OriginTrackedValue)val).getValue();
                    }
                    filtered.put(index, val);
                }
                map.put(key, filtered);
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            combinedMap.putAll((Map)entry.getValue());
        }
        return this.postProcessProperties(combinedMap, (Environment)environment);
    }

    private Map<String, String> postProcessProperties(Map<String, Object> propertiesMap, Environment environment) {
        propertiesMap.keySet().removeIf(key -> key.equals("spring.profiles"));
        return propertiesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> environment.resolvePlaceholders(String.valueOf(entry.getValue())).replace("$_{", "${")));
    }

    private Map<String, Object> createNestedMap(Map<String, String> properties) {
        LinkedHashMap<String, Object> rootMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            PropertyNavigator nav = new PropertyNavigator(key);
            nav.setMapValue(rootMap, value);
        }
        return rootMap;
    }

    private static final class PropertyNavigator {
        private final String propertyKey;
        private String prefix = "";
        private int currentPos;
        private NodeType valueType;

        private PropertyNavigator(String propertyKey) {
            this.propertyKey = propertyKey;
            this.currentPos = -1;
            this.valueType = NodeType.MAP;
        }

        private void setMapValue(Map<String, Object> map, Object value) {
            String key = this.getKey();
            if (NodeType.MAP.equals((Object)this.valueType)) {
                Map<String, Object> nestedMap;
                if (map.get(key) instanceof Map) {
                    nestedMap = (LinkedHashMap<String, Object>)map.get(key);
                } else if (map.get(key) != null) {
                    this.prefix = key + ".";
                    nestedMap = map;
                } else {
                    nestedMap = new LinkedHashMap<String, Object>();
                    map.put(key, nestedMap);
                }
                this.setMapValue(nestedMap, value);
            } else if (NodeType.ARRAY.equals((Object)this.valueType)) {
                ArrayList<Object> list = (ArrayList<Object>)map.get(key);
                if (list == null) {
                    list = new ArrayList<Object>();
                    map.put(key, list);
                }
                this.setListValue(list, value);
            } else {
                map.put(this.prefix + key, value);
            }
        }

        private void setListValue(List<Object> list, Object value) {
            int index = this.getIndex();
            while (list.size() <= index) {
                list.add(null);
            }
            if (NodeType.MAP.equals((Object)this.valueType)) {
                LinkedHashMap<String, Object> map = (LinkedHashMap<String, Object>)list.get(index);
                if (map == null) {
                    map = new LinkedHashMap<String, Object>();
                    list.set(index, map);
                }
                this.setMapValue(map, value);
            } else if (NodeType.ARRAY.equals((Object)this.valueType)) {
                ArrayList<Object> nestedList = (ArrayList<Object>)list.get(index);
                if (nestedList == null) {
                    nestedList = new ArrayList<Object>();
                    list.set(index, nestedList);
                }
                this.setListValue(nestedList, value);
            } else {
                list.set(index, value);
            }
        }

        private int getIndex() {
            int start;
            for (int i = start = this.currentPos + 1; i < this.propertyKey.length(); ++i) {
                char c = this.propertyKey.charAt(i);
                if (c == ']') {
                    this.currentPos = i;
                    break;
                }
                if (Character.isDigit(c)) continue;
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            if (this.currentPos < start || this.currentPos == start) {
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            int index = Integer.parseInt(this.propertyKey.substring(start, this.currentPos));
            ++this.currentPos;
            if (this.currentPos == this.propertyKey.length()) {
                this.valueType = NodeType.LEAF;
            } else {
                switch (this.propertyKey.charAt(this.currentPos)) {
                    case '.': {
                        this.valueType = NodeType.MAP;
                        break;
                    }
                    case '[': {
                        this.valueType = NodeType.ARRAY;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
                    }
                }
            }
            return index;
        }

        private String getKey() {
            int start;
            for (int i = start = this.currentPos + 1; i < this.propertyKey.length(); ++i) {
                char currentChar = this.propertyKey.charAt(i);
                if (currentChar == '.') {
                    this.valueType = NodeType.MAP;
                    this.currentPos = i;
                    break;
                }
                if (currentChar != '[') continue;
                this.valueType = NodeType.ARRAY;
                this.currentPos = i;
                break;
            }
            if (this.currentPos < start) {
                this.currentPos = this.propertyKey.length();
                this.valueType = NodeType.LEAF;
            } else if (this.currentPos == start) {
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            return this.propertyKey.substring(start, this.currentPos);
        }

        private static enum NodeType {
            LEAF,
            MAP,
            ARRAY;

        }
    }
}

