/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import hudson.CloseProofOutputStream;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.RemoteOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.springconfig.EnvironmentWrapper;
import org.jenkinsci.plugins.springconfig.SpringConfigAction;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class SpringConfigStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> profiles = new ArrayList<String>();
    private String location;
    private boolean hideInBuildPage = false;

    @DataBoundSetter
    public void setProfiles(List<String> profiles) {
        this.profiles = ImmutableList.copyOf(profiles);
    }

    public List<String> getProfiles() {
        return ImmutableList.copyOf(this.profiles);
    }

    @DataBoundSetter
    public void setLocation(String location) {
        this.location = location;
    }

    @DataBoundSetter
    public void setHideInBuildPage(boolean hideInBuildPage) {
        this.hideInBuildPage = hideInBuildPage;
    }

    @DataBoundConstructor
    public SpringConfigStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SpringProfileExecution(context, this);
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isHideInBuildPage() {
        return this.hideInBuildPage;
    }

    @Configuration
    public static class EmtpyConfiguration {
    }

    public static class SpringProfileExecution
    extends SynchronousStepExecution<EnvironmentWrapper> {
        private final SpringConfigStep step;

        protected SpringProfileExecution(@Nonnull StepContext context, SpringConfigStep step) {
            super(context);
            this.step = step;
        }

        protected EnvironmentWrapper run() {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Run run = (Run)this.getContext().get(Run.class);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            EnvironmentWrapper environmentWrapper = Optional.ofNullable(launcher).map(Launcher::getChannel).map(channel -> {
                try {
                    return (EnvironmentWrapper)channel.call((Callable)new Execution(this.step.getProfiles(), this.step.getLocation(), listener.getLogger(), ws));
                }
                catch (IOException | InterruptedException | RuntimeException e) {
                    return null;
                }
            }).orElse(null);
            if (!this.step.isHideInBuildPage() && environmentWrapper != null) {
                SpringConfigAction springConfigAction = (SpringConfigAction)run.getAction(SpringConfigAction.class);
                if (springConfigAction == null) {
                    springConfigAction = new SpringConfigAction();
                    run.addAction((Action)springConfigAction);
                }
                springConfigAction.addProperties(environmentWrapper.getProfilesAsString(), environmentWrapper.asProperties());
                run.save();
            }
            return environmentWrapper;
        }

        public static class Execution
        extends MasterToSlaveCallable<EnvironmentWrapper, RuntimeException> {
            private static final long serialVersionUID = 1L;
            private final List<String> profiles;
            private final String location;
            private final RemoteOutputStream remoteLogger;
            private final FilePath ws;
            private transient PrintStream localLogger;

            public Execution(List<String> profiles, String location, PrintStream logger, FilePath ws) {
                this.profiles = ImmutableList.copyOf(profiles);
                this.location = location;
                this.localLogger = logger;
                this.remoteLogger = new RemoteOutputStream((OutputStream)new CloseProofOutputStream((OutputStream)logger));
                this.ws = ws;
            }

            public EnvironmentWrapper call() {
                StandardEnvironment environment = new StandardEnvironment();
                HashMap<String, String> configFilesMap = new HashMap<String, String>();
                if (this.location != null && !this.location.equals("")) {
                    String newLocation = Arrays.stream(this.location.split(",")).map(single -> {
                        String remoteLocation = new FilePath(this.ws, single).getRemote();
                        char lastChar = single.charAt(single.length() - 1);
                        if (lastChar == '/' || lastChar == '\\') {
                            remoteLocation = remoteLocation + lastChar;
                        }
                        return remoteLocation;
                    }).collect(Collectors.joining(","));
                    configFilesMap.put("spring.config.location", newLocation);
                } else {
                    configFilesMap.put("spring.config.location", this.ws.getRemote() + "/");
                }
                MapPropertySource mapPropertySource = new MapPropertySource("configfiles", configFilesMap);
                environment.getPropertySources().addFirst((PropertySource)mapPropertySource);
                SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[0]).profiles(this.profiles.toArray(new String[0])).bannerMode(Banner.Mode.OFF).environment((ConfigurableEnvironment)environment).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE).sources(new Class[]{EmtpyConfiguration.class});
                builder.run(new String[0]).close();
                this.getLogger().print(environment);
                return new EnvironmentWrapper(environment);
            }

            private PrintStream getLogger() {
                if (this.localLogger == null) {
                    this.localLogger = new PrintStream((OutputStream)this.remoteLogger, true, StandardCharsets.UTF_8.name());
                }
                return this.localLogger;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "springConfig";
        }

        public String getDisplayName() {
            return "A step to read spring style profile configs";
        }
    }
}

