/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.springconfig.SpringProfilesLoader;
import org.jenkinsci.plugins.springconfig.SpringProfilesStore;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class SpringProfilesJobProperty
extends JobProperty<Job<?, ?>>
implements SpringProfilesStore {
    private static final Logger log = Logger.getLogger(SpringProfilesJobProperty.class.getName());
    @DataBoundSetter
    private String springProfiles = "";

    @DataBoundConstructor
    public SpringProfilesJobProperty(String springProfiles) {
        this.springProfiles = springProfiles;
        log.log(Level.FINER, "Instantiating new SpringProfilesJobProperty\n");
    }

    public SpringProfilesJobProperty reconfigure(StaplerRequest request, JSONObject formData) {
        if (formData == null) {
            return null;
        }
        this.springProfiles = formData.getString("springProfiles");
        return this;
    }

    static List<String> retrieveSpringProfilesFromJobConfig(Job job) {
        return Optional.ofNullable(job).map(thisJob -> thisJob.getProperty(SpringProfilesJobProperty.class)).map(SpringProfilesJobProperty.class::cast).map(SpringProfilesLoader::retrieveSpringProfilesFromStore).orElseGet(Collections::emptyList);
    }

    @Override
    public String getSpringProfiles() {
        return this.springProfiles;
    }

    public void setSpringProfiles(String springProfiles) {
        this.springProfiles = springProfiles;
    }

    @Extension(ordinal=-1000.0)
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "z";
        }
    }
}

