/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Job;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;

public class JsonWriter
implements SourceCallback,
Closeable {
    protected static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private final Job job;
    private final File coverallsFile;
    private final JsonGenerator generator;

    public JsonWriter(Job job, File coverallsFile) throws IOException {
        File directory = coverallsFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.job = job;
        this.coverallsFile = coverallsFile;
        this.generator = new MappingJsonFactory().createGenerator(coverallsFile, JsonEncoding.UTF8);
    }

    public final Job getJob() {
        return this.job;
    }

    public final File getCoverallsFile() {
        return this.coverallsFile;
    }

    @Override
    public void onBegin() throws ProcessingException, IOException {
        try {
            this.generator.writeStartObject();
            this.writeOptionalString("repo_token", this.job.getRepoToken());
            this.writeOptionalString("service_name", this.job.getServiceName());
            this.writeOptionalString("service_job_id", this.job.getServiceJobId());
            this.writeOptionalString("service_number", this.job.getServiceBuildNumber());
            this.writeOptionalString("service_build_url", this.job.getServiceBuildUrl());
            this.writeOptionalString("service_branch", this.job.getBranch());
            this.writeOptionalString("service_pull_request", this.job.getPullRequest());
            this.writeOptionalTimestamp("run_at", this.job.getTimestamp());
            this.writeOptionalEnvironment("environment", this.job.getServiceEnvironment());
            this.writeOptionalObject("git", this.job.getGit());
            this.generator.writeArrayFieldStart("source_files");
        }
        catch (JsonProcessingException ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public void onSource(Source source) throws ProcessingException, IOException {
        try {
            this.generator.writeObject((Object)source);
        }
        catch (JsonProcessingException ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public void onComplete() throws ProcessingException, IOException {
        try {
            this.generator.writeEndArray();
            this.generator.writeEndObject();
        }
        catch (JsonProcessingException ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }

    private void writeOptionalString(String field, String value) throws ProcessingException, IOException {
        if (StringUtils.isNotBlank((String)value)) {
            this.generator.writeStringField(field, value);
        }
    }

    private void writeOptionalObject(String field, Object value) throws ProcessingException, IOException {
        if (value != null) {
            this.generator.writeObjectField(field, value);
        }
    }

    private void writeOptionalTimestamp(String field, Date value) throws ProcessingException, IOException {
        if (value != null) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            this.writeOptionalString(field, format.format(value));
        }
    }

    private void writeOptionalEnvironment(String field, Properties properties) throws ProcessingException, IOException {
        if (properties != null) {
            this.generator.writeObjectFieldStart(field);
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                this.writeOptionalString(property.getKey().toString(), property.getValue().toString());
            }
            this.generator.writeEndObject();
        }
    }
}

