/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent;

import java.lang.instrument.Instrumentation;
import java.text.MessageFormat;
import kanela.agent.api.instrumentation.InstrumentationBuilder;
import kanela.agent.builder.AgentInstaller;
import kanela.agent.builder.KanelaFileTransformer;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.log.Logger;

public class InstrumentationLoader {
    public static List<KanelaFileTransformer> load(Instrumentation instrumentation, ClassLoader ctxClassloader, KanelaConfiguration configuration) {
        return configuration.getAgentModules().map(moduleConfiguration -> {
            Logger.info(() -> MessageFormat.format("Loading {0} ", moduleConfiguration.getName()));
            return moduleConfiguration.getInstrumentations().flatMap(instrumentationClassName -> InstrumentationLoader.loadInstrumentation(instrumentationClassName, ctxClassloader)).filter(kanelaInstrumentation -> kanelaInstrumentation.isEnabled((KanelaConfiguration.ModuleConfiguration)moduleConfiguration)).sortBy(InstrumentationBuilder::order).flatMap(kanelaInstrumentation -> kanelaInstrumentation.collectTransformations((KanelaConfiguration.ModuleConfiguration)moduleConfiguration, instrumentation)).foldLeft(AgentInstaller.from(configuration, moduleConfiguration, instrumentation), AgentInstaller::addTypeTransformation).install();
        });
    }

    private static Option<InstrumentationBuilder> loadInstrumentation(String instrumentationClassName, ClassLoader classLoader) {
        Logger.info(() -> MessageFormat.format(" ==> Loading {0} ", instrumentationClassName));
        try {
            return Option.some((InstrumentationBuilder)Class.forName(instrumentationClassName, true, classLoader).newInstance());
        }
        catch (Throwable cause) {
            Logger.warn(() -> MessageFormat.format("Error trying to load Instrumentation: {0} with error: {1}", instrumentationClassName, cause));
            return Option.none();
        }
    }
}

