/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent;

import java.lang.instrument.Instrumentation;
import kanela.agent.InstrumentationLoader;
import kanela.agent.api.instrumentation.listener.InstrumentationRegistryListener;
import kanela.agent.api.instrumentation.replacer.ClassReplacer;
import kanela.agent.builder.KanelaFileTransformer;
import kanela.agent.circuitbreaker.SystemThroughputCircuitBreaker;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.reinstrument.Reinstrumenter;
import kanela.agent.util.BootstrapInjector;
import kanela.agent.util.Execution;
import kanela.agent.util.banner.KanelaBanner;
import kanela.agent.util.classloader.InstrumentationClassPath;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.jvm.OldGarbageCollectorListener;
import kanela.agent.util.log.Logger;

public final class Kanela {
    private static String loadedPropertyName = "kanela.loaded";
    private static volatile Instrumentation instrumentation;
    private static volatile List<KanelaFileTransformer> installedTransformers;

    public static void premain(String args, Instrumentation instrumentation) {
        Kanela.start(args, instrumentation, false);
    }

    public static void agentmain(String args, Instrumentation instrumentation) {
        Kanela.start(args, instrumentation, true);
    }

    public static void start(String arguments, Instrumentation instrumentation, boolean isRuntimeAttach) {
        if (Kanela.instrumentation == null) {
            Kanela.instrumentation = instrumentation;
            Execution.runWithTimeSpent(() -> InstrumentationClassPath.build().use(instrumentationClassLoader -> {
                BootstrapInjector.injectJar(instrumentation, "bootstrap");
                KanelaConfiguration configuration = KanelaConfiguration.from(instrumentationClassLoader);
                Logger.configureLogger(configuration);
                if (isRuntimeAttach) {
                    configuration.runtimeAttach();
                }
                KanelaBanner.show(configuration);
                installedTransformers = InstrumentationLoader.load(instrumentation, instrumentationClassLoader, configuration);
                Reinstrumenter.attach(instrumentation, configuration, installedTransformers);
                OldGarbageCollectorListener.attach(configuration.getOldGarbageCollectorConfig());
                SystemThroughputCircuitBreaker.attach(configuration.getCircuitBreakerConfig());
                ClassReplacer.attach(instrumentation, configuration.getClassReplacerConfig());
                Kanela.updateLoadedSystemProperty();
            }));
        }
    }

    public static void reload() {
        if (instrumentation != null) {
            InstrumentationRegistryListener.instance().clear();
            InstrumentationClassPath.build().use(instrumentationClassLoader -> {
                installedTransformers.forEach(transformer -> instrumentation.removeTransformer(transformer.getClassFileTransformer()));
                installedTransformers = List.empty();
                KanelaConfiguration configuration = KanelaConfiguration.from(instrumentationClassLoader);
                Logger.configureLogger(configuration);
                installedTransformers = InstrumentationLoader.load(instrumentation, instrumentationClassLoader, configuration);
            });
        }
    }

    private static void updateLoadedSystemProperty() {
        System.setProperty(loadedPropertyName, "true");
    }

    static {
        installedTransformers = List.empty();
    }
}

