/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kanela.agent.api.instrumentation.classloader.ClassLoaderRefiner;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;

public final class TypeTransformation {
    private final String instrumentationName;
    private final Option<ElementMatcher<? super TypeDescription>> elementMatcher;
    private final Option<ClassLoaderRefiner> classLoaderRefiner;
    private final List<AgentBuilder.Transformer> bridges;
    private final List<AgentBuilder.Transformer> mixins;
    private final List<AgentBuilder.Transformer> transformations;

    @SafeVarargs
    static TypeTransformation of(String instrumentationName, Option<ElementMatcher<? super TypeDescription>> elementMatcher, Option<ClassLoaderRefiner> classLoaderRefiner, List<AgentBuilder.Transformer> bridges, List<AgentBuilder.Transformer> mixins, List<AgentBuilder.Transformer> ... transformers) {
        List<AgentBuilder.Transformer> transformations = Arrays.stream(transformers).flatMap(Collection::stream).collect(Collectors.toList());
        return new TypeTransformation(instrumentationName, elementMatcher, classLoaderRefiner, bridges, mixins, transformations);
    }

    public Boolean isActive() {
        return true;
    }

    public TypeTransformation(String instrumentationName, Option<ElementMatcher<? super TypeDescription>> elementMatcher, Option<ClassLoaderRefiner> classLoaderRefiner, List<AgentBuilder.Transformer> bridges, List<AgentBuilder.Transformer> mixins, List<AgentBuilder.Transformer> transformations) {
        this.instrumentationName = instrumentationName;
        this.elementMatcher = elementMatcher;
        this.classLoaderRefiner = classLoaderRefiner;
        this.bridges = bridges;
        this.mixins = mixins;
        this.transformations = transformations;
    }

    public String getInstrumentationName() {
        return this.instrumentationName;
    }

    public Option<ElementMatcher<? super TypeDescription>> getElementMatcher() {
        return this.elementMatcher;
    }

    public Option<ClassLoaderRefiner> getClassLoaderRefiner() {
        return this.classLoaderRefiner;
    }

    public List<AgentBuilder.Transformer> getBridges() {
        return this.bridges;
    }

    public List<AgentBuilder.Transformer> getMixins() {
        return this.mixins;
    }

    public List<AgentBuilder.Transformer> getTransformations() {
        return this.transformations;
    }

    public String toString() {
        return "TypeTransformation(instrumentationName=" + this.getInstrumentationName() + ", elementMatcher=" + this.getElementMatcher() + ", classLoaderRefiner=" + this.getClassLoaderRefiner() + ", bridges=" + this.getBridges() + ", mixins=" + this.getMixins() + ", transformations=" + this.getTransformations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeTransformation)) {
            return false;
        }
        TypeTransformation other = (TypeTransformation)o;
        String this$instrumentationName = this.getInstrumentationName();
        String other$instrumentationName = other.getInstrumentationName();
        return !(this$instrumentationName == null ? other$instrumentationName != null : !this$instrumentationName.equals(other$instrumentationName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $instrumentationName = this.getInstrumentationName();
        result = result * 59 + ($instrumentationName == null ? 43 : $instrumentationName.hashCode());
        return result;
    }
}

