/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.legacy;

import kanela.agent.libs.net.bytebuddy.ClassFileVersion;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassVisitor;
import kanela.agent.libs.net.bytebuddy.utility.OpenedClassReader;

public final class ClassFileVersionValidatorClassVisitor
extends ClassVisitor {
    public static ClassFileVersionValidatorClassVisitor from(ClassVisitor classVisitor) {
        return new ClassFileVersionValidatorClassVisitor(classVisitor);
    }

    private ClassFileVersionValidatorClassVisitor(ClassVisitor classVisitor) {
        super(OpenedClassReader.ASM_API, classVisitor);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ClassFileVersion classFileVersion = ClassFileVersion.ofMinorMajor(version);
        if (classFileVersion.isLessThan(ClassFileVersion.JAVA_V5)) {
            throw NoStackTraceUnsupportedClassFileVersion.Instance;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public String toString() {
        return "ClassFileVersionValidatorClassVisitor()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassFileVersionValidatorClassVisitor)) {
            return false;
        }
        ClassFileVersionValidatorClassVisitor other = (ClassFileVersionValidatorClassVisitor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassFileVersionValidatorClassVisitor;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static final class NoStackTraceUnsupportedClassFileVersion
    extends RuntimeException {
        public static NoStackTraceUnsupportedClassFileVersion Instance = new NoStackTraceUnsupportedClassFileVersion();

        private NoStackTraceUnsupportedClassFileVersion() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return "ClassFileVersionValidatorClassVisitor.NoStackTraceUnsupportedClassFileVersion()";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NoStackTraceUnsupportedClassFileVersion)) {
                return false;
            }
            NoStackTraceUnsupportedClassFileVersion other = (NoStackTraceUnsupportedClassFileVersion)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof NoStackTraceUnsupportedClassFileVersion;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

