/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.mixin;

import java.io.InputStream;
import java.util.function.Predicate;
import kanela.agent.api.instrumentation.mixin.MixinDescription;
import kanela.agent.api.instrumentation.mixin.MixinInitializer;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassReader;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassVisitor;
import kanela.agent.libs.net.bytebuddy.jar.asm.MethodVisitor;
import kanela.agent.libs.net.bytebuddy.jar.asm.Type;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.MethodRemapper;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.SimpleRemapper;
import kanela.agent.libs.net.bytebuddy.jar.asm.tree.ClassNode;
import kanela.agent.libs.net.bytebuddy.jar.asm.tree.MethodNode;
import kanela.agent.libs.net.bytebuddy.utility.OpenedClassReader;

public final class MixinClassVisitor
extends ClassVisitor {
    static final String ConstructorDescriptor = "<init>";
    private final MixinDescription mixin;
    private final Type type;

    public static MixinClassVisitor from(MixinDescription mixin, String className, ClassVisitor classVisitor) {
        return new MixinClassVisitor(mixin, className, classVisitor);
    }

    private MixinClassVisitor(MixinDescription mixin, String className, ClassVisitor classVisitor) {
        super(OpenedClassReader.ASM_API, classVisitor);
        this.mixin = mixin;
        this.type = Type.getObjectType(className);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals(ConstructorDescriptor) && this.mixin.getInitializerMethod().isDefined()) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new MixinInitializer(mv, access, name, desc, this.type, this.mixin);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String mixinClassFileName = this.mixin.getMixinClass().getName().replace('.', '/') + ".class";
        InputStream classStream = classLoader.getResourceAsStream(mixinClassFileName);
        ClassReader cr = new ClassReader(classStream);
        classStream.close();
        ClassNode cn = new ClassNode();
        cr.accept(cn, 8);
        cn.fields.forEach(fieldNode -> fieldNode.accept(this));
        cn.methods.stream().filter(MixinClassVisitor.isConstructor()).forEach(mn -> {
            String[] exceptions = new String[mn.exceptions.size()];
            MethodVisitor mv = this.cv.visitMethod(mn.access, mn.name, mn.desc, mn.signature, exceptions);
            mn.accept(new MethodRemapper(mv, new SimpleRemapper(cn.name, this.type.getInternalName())));
        });
        super.visitEnd();
    }

    private static Predicate<MethodNode> isConstructor() {
        return p -> !p.name.equals(ConstructorDescriptor);
    }

    public MixinDescription getMixin() {
        return this.mixin;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "MixinClassVisitor(mixin=" + this.getMixin() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MixinClassVisitor)) {
            return false;
        }
        MixinClassVisitor other = (MixinClassVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MixinDescription this$mixin = this.getMixin();
        MixinDescription other$mixin = other.getMixin();
        if (this$mixin == null ? other$mixin != null : !((Object)this$mixin).equals(other$mixin)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MixinClassVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MixinDescription $mixin = this.getMixin();
        result = result * 59 + ($mixin == null ? 43 : ((Object)$mixin).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }
}

