/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.mixin;

import kanela.agent.api.instrumentation.mixin.MixinDescription;
import kanela.agent.libs.net.bytebuddy.jar.asm.MethodVisitor;
import kanela.agent.libs.net.bytebuddy.jar.asm.Type;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.AdviceAdapter;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.Method;
import kanela.agent.libs.net.bytebuddy.utility.OpenedClassReader;

public class MixinInitializer
extends AdviceAdapter {
    private static final String ConstructorDescriptor = "<init>";
    private final Type typeClass;
    private final MixinDescription mixinDescription;
    private boolean cascadingConstructor;

    MixinInitializer(MethodVisitor mv, int access, String name, String desc, Type typeClass, MixinDescription mixinDescription) {
        super(OpenedClassReader.ASM_API, mv, access, name, desc);
        this.typeClass = typeClass;
        this.mixinDescription = mixinDescription;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (name.equals(ConstructorDescriptor) && owner.equals(this.typeClass.getInternalName())) {
            this.cascadingConstructor = true;
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (this.cascadingConstructor) {
            return;
        }
        this.mixinDescription.getInitializerMethod().forEach(methodName -> {
            this.loadThis();
            this.invokeVirtual(this.typeClass, new Method((String)methodName, "()V"));
        });
    }
}

