/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.replacer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import kanela.agent.libs.io.vavr.collection.Map;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassReader;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassWriter;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.ClassRemapper;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.SimpleRemapper;
import kanela.agent.util.annotation.Experimental;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.log.Logger;

@Experimental
public final class ClassReplacer {
    public static void attach(Instrumentation instrumentation, KanelaConfiguration.ClassReplacerConfig configuration) {
        if (configuration.classesToReplace().nonEmpty()) {
            Try.run(() -> instrumentation.addTransformer(new ClassReplacerTransformer(configuration.classesToReplace()))).andThen(() -> Logger.info(() -> "Class Replacer activated.")).onFailure(cause -> Logger.warn(() -> "Error when trying to activate Class Replacer.", cause));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ClassReplacer;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ClassReplacer()";
    }

    static final class ClassReplacerTransformer
    implements ClassFileTransformer {
        private final Map<String, String> classesToReplace;

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            return this.classesToReplace.get(className).map(resource -> Try.of(() -> ClassReplacerTransformer.remapResource(className, resource, loader)).onFailure(cause -> Logger.warn(() -> "Error trying to Replace Class: " + className, cause)).getOrElse(() -> classfileBuffer)).getOrElse(classfileBuffer);
        }

        private static byte[] remapResource(String classToReplace, String resource, ClassLoader loader) throws IOException {
            try (InputStream in = loader.getResourceAsStream(resource + ".class");){
                ClassReader reader = new ClassReader(in);
                ClassWriter classWriter = new ClassWriter(0);
                reader.accept(new ClassRemapper(classWriter, new SimpleRemapper(resource, classToReplace)), 8);
                byte[] byArray = classWriter.toByteArray();
                return byArray;
            }
        }

        public ClassReplacerTransformer(Map<String, String> classesToReplace) {
            this.classesToReplace = classesToReplace;
        }

        public Map<String, String> getClassesToReplace() {
            return this.classesToReplace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassReplacerTransformer)) {
                return false;
            }
            ClassReplacerTransformer other = (ClassReplacerTransformer)o;
            Map<String, String> this$classesToReplace = this.getClassesToReplace();
            Map<String, String> other$classesToReplace = other.getClassesToReplace();
            return !(this$classesToReplace == null ? other$classesToReplace != null : !this$classesToReplace.equals(other$classesToReplace));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $classesToReplace = this.getClassesToReplace();
            result = result * 59 + ($classesToReplace == null ? 43 : $classesToReplace.hashCode());
            return result;
        }

        public String toString() {
            return "ClassReplacer.ClassReplacerTransformer(classesToReplace=" + this.getClassesToReplace() + ")";
        }
    }
}

