/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog.labelers;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.EnvironmentHelper;
import kanela.agent.libs.org.pmw.tinylog.InternalLogger;
import kanela.agent.libs.org.pmw.tinylog.labelers.Labeler;
import kanela.agent.libs.org.pmw.tinylog.labelers.LogFileComparator;
import kanela.agent.libs.org.pmw.tinylog.labelers.LogFileFilter;
import kanela.agent.libs.org.pmw.tinylog.labelers.PropertiesSupport;

@PropertiesSupport(name="timestamp")
public final class TimestampLabeler
implements Labeler {
    private static final String DEFAULT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH-mm-ss";
    private final String pattern;
    private TimestampFormatter formatter;
    private LogFileFilter logFileFilter;
    private String directory;
    private String filenameWithoutExtension;
    private String filenameExtension;

    public TimestampLabeler() {
        this(DEFAULT_TIMESTAMP_PATTERN);
    }

    public TimestampLabeler(String string) {
        this.pattern = string;
    }

    @Override
    public void init(Configuration configuration) {
        if (this.pattern.contains("SSSS") || this.pattern.contains("n") || this.pattern.contains("N")) {
            if (EnvironmentHelper.isAtLeastJava9()) {
                this.formatter = new PreciseTimestampFormatter(this.pattern, configuration.getLocale());
            } else {
                InternalLogger.warn("Java supports microseconds and nanoseconds only from version 9 onwards");
                this.formatter = new LegacyTimestampFormatter(this.pattern, configuration.getLocale());
            }
        } else {
            this.formatter = new LegacyTimestampFormatter(this.pattern, configuration.getLocale());
        }
    }

    @Override
    public File getLogFile(File file, int n) {
        this.directory = file.getAbsoluteFile().getParent();
        String string = file.getName();
        int n2 = string.indexOf(46, 1);
        if (n2 > 0) {
            this.filenameWithoutExtension = string.substring(0, n2);
            this.filenameExtension = string.substring(n2);
        } else {
            this.filenameWithoutExtension = string;
            this.filenameExtension = "";
        }
        this.logFileFilter = new LogFileFilter(this.filenameWithoutExtension, this.filenameExtension);
        this.delete(file.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter), n);
        return this.createFile();
    }

    @Override
    public File roll(File file, int n) {
        this.delete(file.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter), n);
        return this.createFile();
    }

    private File createFile() {
        return new File(this.directory, this.filenameWithoutExtension + "." + this.formatter.getCurrentTimestamp() + this.filenameExtension);
    }

    private void delete(File[] fileArray, int n) {
        if (fileArray != null && fileArray.length > n) {
            Arrays.sort(fileArray, LogFileComparator.getInstance());
            for (int i = n; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (file.delete()) continue;
                InternalLogger.warn("Failed to delete \"{}\"", file);
            }
        }
    }

    private static final class PreciseTimestampFormatter
    implements TimestampFormatter {
        private final DateTimeFormatter formatter;

        private PreciseTimestampFormatter(String string, Locale locale) {
            this.formatter = DateTimeFormatter.ofPattern(string, locale).withZone(ZoneId.systemDefault());
        }

        @Override
        public String getCurrentTimestamp() {
            return this.formatter.format(Instant.now());
        }
    }

    private static final class LegacyTimestampFormatter
    implements TimestampFormatter {
        private final DateFormat format;

        private LegacyTimestampFormatter(String string, Locale locale) {
            this.format = new SimpleDateFormat(string, locale);
        }

        @Override
        public String getCurrentTimestamp() {
            return this.format.format(new Date());
        }
    }

    private static interface TimestampFormatter {
        public String getCurrentTimestamp();
    }
}

