/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kanela.agent.api.instrumentation.classloader.ClassRefiner;
import kanela.agent.libs.io.vavr.Tuple;
import kanela.agent.libs.io.vavr.collection.Array;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassReader;
import kanela.agent.libs.net.bytebuddy.jar.asm.Type;
import kanela.agent.libs.net.bytebuddy.jar.asm.tree.ClassNode;
import kanela.agent.libs.net.bytebuddy.utility.OpenedClassReader;
import kanela.agent.util.classloader.ClassMatcher;
import kanela.agent.util.log.Logger;

public final class AnalyzedClass
implements ClassMatcher {
    private final ClassRefiner classRefiner;
    private final Set<String> fields;
    private final Map<String, Set<String>> methodsWithArguments;

    public static ClassMatcher from(ClassRefiner refiner, ClassLoader loader) {
        return Try.of(() -> {
            String target = refiner.getTarget();
            String resourceName = target.replace('.', '/') + ".class";
            try (InputStream in = loader.getResourceAsStream(resourceName);){
                ClassNode classNode = AnalyzedClass.convertToClassNode(in);
                AnalyzedClass analyzedClass = new AnalyzedClass(refiner, AnalyzedClass.extractFields(classNode), AnalyzedClass.extractMethods(classNode));
                return analyzedClass;
            }
        }).onFailure(cause -> Logger.debug(() -> "Error trying to build an AnalyzedClass: " + cause.getMessage())).getOrElse(new NoOpAnalyzedClass());
    }

    @Override
    public Boolean match() {
        boolean evaluated = this.buildClassRefinerPredicate(this.classRefiner).test(true);
        if (!evaluated) {
            Logger.debug(() -> "The Class: " + this.classRefiner.getTarget() + " was filtered because not match with the provided ClassRefined: " + this.classRefiner);
        }
        return evaluated;
    }

    private Boolean containsFields(String ... fields) {
        return this.fields.containsAll(Arrays.asList(fields));
    }

    private Boolean containsMethod(String methodName, String ... parameters) {
        if (this.methodsWithArguments.containsKey(methodName)) {
            Set<String> parameterSet = this.methodsWithArguments.get(methodName);
            if (parameters.length > 0) {
                return Arrays.asList(parameters).containsAll(parameterSet);
            }
            return true;
        }
        return false;
    }

    private Predicate<Boolean> buildClassRefinerPredicate(ClassRefiner classRefiner) {
        List<Predicate> allPredicates = Arrays.asList(p -> this.containsFields(classRefiner.getFields().toArray(new String[0])), p -> this.containsMethodWithParameters(classRefiner.getMethods()));
        return allPredicates.stream().reduce(p -> true, Predicate::and);
    }

    private Boolean containsMethodWithParameters(Map<String, Set<String>> methods) {
        if (methods.isEmpty()) {
            return true;
        }
        return !methods.entrySet().stream().map(entry -> this.containsMethod((String)entry.getKey(), ((Set)entry.getValue()).toArray(new String[0]))).collect(Collectors.toSet()).contains(false);
    }

    private static Set<String> extractFields(ClassNode classNode) {
        return kanela.agent.libs.io.vavr.collection.List.ofAll(classNode.fields).map(fieldNode -> fieldNode.name).toJavaSet();
    }

    private static Map<String, Set<String>> extractMethods(ClassNode classNode) {
        return kanela.agent.libs.io.vavr.collection.List.ofAll(classNode.methods).filter(methodNode -> (methodNode.access & 0x1000) == 0).toJavaMap(methodNode -> Tuple.of(methodNode.name, Array.of(Type.getArgumentTypes(methodNode.desc)).map(AnalyzedClass::getType).toJavaSet()));
    }

    private static String getType(Type methodDescription) {
        return methodDescription.getInternalName().replace('/', '.');
    }

    private static ClassNode convertToClassNode(InputStream classBytes) throws IOException {
        ClassNode result = new ClassNode(OpenedClassReader.ASM_API);
        ClassReader reader = new ClassReader(classBytes);
        reader.accept(result, 4);
        return result;
    }

    public AnalyzedClass(ClassRefiner classRefiner, Set<String> fields, Map<String, Set<String>> methodsWithArguments) {
        this.classRefiner = classRefiner;
        this.fields = fields;
        this.methodsWithArguments = methodsWithArguments;
    }

    public ClassRefiner getClassRefiner() {
        return this.classRefiner;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public Map<String, Set<String>> getMethodsWithArguments() {
        return this.methodsWithArguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyzedClass)) {
            return false;
        }
        AnalyzedClass other = (AnalyzedClass)o;
        ClassRefiner this$classRefiner = this.getClassRefiner();
        ClassRefiner other$classRefiner = other.getClassRefiner();
        if (this$classRefiner == null ? other$classRefiner != null : !((Object)this$classRefiner).equals(other$classRefiner)) {
            return false;
        }
        Set<String> this$fields = this.getFields();
        Set<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Map<String, Set<String>> this$methodsWithArguments = this.getMethodsWithArguments();
        Map<String, Set<String>> other$methodsWithArguments = other.getMethodsWithArguments();
        return !(this$methodsWithArguments == null ? other$methodsWithArguments != null : !((Object)this$methodsWithArguments).equals(other$methodsWithArguments));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassRefiner $classRefiner = this.getClassRefiner();
        result = result * 59 + ($classRefiner == null ? 43 : ((Object)$classRefiner).hashCode());
        Set<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Map<String, Set<String>> $methodsWithArguments = this.getMethodsWithArguments();
        result = result * 59 + ($methodsWithArguments == null ? 43 : ((Object)$methodsWithArguments).hashCode());
        return result;
    }

    public String toString() {
        return "AnalyzedClass(classRefiner=" + this.getClassRefiner() + ", fields=" + this.getFields() + ", methodsWithArguments=" + this.getMethodsWithArguments() + ")";
    }

    static class NoOpAnalyzedClass
    implements ClassMatcher {
        NoOpAnalyzedClass() {
        }

        @Override
        public Boolean match() {
            return false;
        }
    }
}

