/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.classloader;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.function.Consumer;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.util.BuiltInModuleLoader;
import kanela.agent.util.Lang;
import kanela.agent.util.classloader.ChildFirstURLClassLoader;

public class InstrumentationClassPath {
    private final ClassLoader classLoader;
    private static final String SecondaryClassLoaderPropertyName = "kanela.instrumentation.classLoader";

    private InstrumentationClassPath() {
        URL[] builtInModules = BuiltInModuleLoader.findModules();
        this.classLoader = this.findSecondaryClassLoader().map(cl -> new ChildFirstURLClassLoader(builtInModules, (ClassLoader)cl)).getOrElse(() -> new ChildFirstURLClassLoader(builtInModules, this.getParentClassLoader()));
    }

    private Option<ClassLoader> findSecondaryClassLoader() {
        return Try.of(() -> (ClassLoader)System.getProperties().get(SecondaryClassLoaderPropertyName)).andFinally(() -> System.getProperties().remove(SecondaryClassLoaderPropertyName)).toOption();
    }

    public static InstrumentationClassPath build() {
        return new InstrumentationClassPath();
    }

    public void use(Consumer<ClassLoader> thunk) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            thunk.accept(this.classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private ClassLoader getParentClassLoader() {
        return Try.of(() -> {
            String javaVersion = Lang.getRunningJavaVersion();
            if (javaVersion.startsWith("1.7") || javaVersion.startsWith("1.8")) {
                return null;
            }
            Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
            return (ClassLoader)method.invoke(null, new Object[0]);
        }).getOrElse(() -> null);
    }
}

