/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;

public class ScalaCompilerClassLoaderMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    private static Set<ClassLoader> knownScalaClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean matches(ClassLoader classLoader) {
        return ScalaCompilerClassLoaderMatcher.isScalaCompilerClassLoader(classLoader);
    }

    public static boolean isScalaCompilerClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            boolean isScalaCompiler;
            if (knownScalaClassLoaders.contains(classLoader)) {
                return true;
            }
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            boolean foundScalaCompiler = false;
            boolean foundJLine = false;
            for (URL url : urlClassLoader.getURLs()) {
                if (url.getFile().contains("scala-compiler")) {
                    foundScalaCompiler = true;
                }
                if (!url.getFile().contains("jline")) continue;
                foundJLine = true;
            }
            boolean bl = isScalaCompiler = foundScalaCompiler && foundJLine;
            if (isScalaCompiler) {
                knownScalaClassLoaders.add(classLoader);
            }
            return isScalaCompiler;
        }
        return false;
    }
}

