/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import io.ktor.utils.io.ByteBufferChannel;
import io.ktor.utils.io.WriterSuspendSession;
import io.ktor.utils.io.core.ByteOrder;
import io.ktor.utils.io.core.IoBuffer;
import io.ktor.utils.io.internal.RingBufferCapacity;
import io.ktor.utils.io.internal.WriteSessionImpl;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0019\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\tH\u0002J$\u0010\u001e\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lio/ktor/utils/io/internal/WriteSessionImpl;", "Lio/ktor/utils/io/WriterSuspendSession;", "channel", "Lio/ktor/utils/io/ByteBufferChannel;", "(Lio/ktor/utils/io/ByteBufferChannel;)V", "byteBuffer", "Ljava/nio/ByteBuffer;", "current", "locked", "", "ringBufferCapacity", "Lio/ktor/utils/io/internal/RingBufferCapacity;", "view", "Lio/ktor/utils/io/core/IoBuffer;", "begin", "", "complete", "flush", "request", "min", "tryAwait", "n", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryAwaitJoinSwitch", "joining", "Lio/ktor/utils/io/ByteBufferChannel$JoiningState;", "(ILio/ktor/utils/io/ByteBufferChannel$JoiningState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "written", "writtenFailed", "", "prepareBuffer", "order", "Lio/ktor/utils/io/core/ByteOrder;", "position", "available", "ktor-io"})
public final class WriteSessionImpl
implements WriterSuspendSession {
    private int locked;
    private ByteBufferChannel current;
    private ByteBuffer byteBuffer;
    private IoBuffer view;
    private RingBufferCapacity ringBufferCapacity;

    public final void begin() {
        this.current = this.current.resolveChannelInstance$ktor_io();
        ByteBuffer byteBuffer = this.current.setupStateForWrite$ktor_io();
        if (byteBuffer == null) {
            return;
        }
        this.byteBuffer = byteBuffer;
        this.view = new IoBuffer(this.current.currentState$ktor_io().backingBuffer);
        this.view.resetFromContentToWrite(this.byteBuffer);
        this.ringBufferCapacity = this.current.currentState$ktor_io().capacity;
    }

    public final void complete() {
        if (this.locked > 0) {
            this.ringBufferCapacity.completeRead(this.locked);
            this.locked = 0;
        }
        this.current.restoreStateAfterWrite$ktor_io();
        this.current.tryTerminate$ktor_io();
    }

    @Override
    @Nullable
    public IoBuffer request(int min) {
        this.locked += this.ringBufferCapacity.tryWriteAtLeast(0);
        if (this.locked < min) {
            return null;
        }
        this.current.prepareWriteBuffer$ktor_io(this.byteBuffer, this.locked);
        if (this.byteBuffer.remaining() < min) {
            return null;
        }
        this.view.resetFromContentToWrite(this.byteBuffer);
        return this.view;
    }

    @Override
    public void written(int n) {
        if (n < 0 || n > this.locked) {
            Void void_ = this.writtenFailed(n);
            throw null;
        }
        this.locked -= n;
        this.current.bytesWrittenFromSesion$ktor_io(this.byteBuffer, this.ringBufferCapacity, n);
    }

    private final Void writtenFailed(int n) {
        if (n < 0) {
            throw (Throwable)new IllegalArgumentException("Written bytes count shouldn't be negative: " + n);
        }
        throw (Throwable)new IllegalStateException("Unable to mark " + n + " bytes as written: only " + this.locked + " were pre-locked.");
    }

    @Override
    @Nullable
    public Object tryAwait(int n, @NotNull Continuation<? super Unit> $completion) {
        ByteBufferChannel.JoiningState joining = this.current.getJoining$ktor_io();
        if (joining != null) {
            Object object = this.tryAwaitJoinSwitch(n, joining, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (this.locked >= n) {
            return Unit.INSTANCE;
        }
        if (this.locked > 0) {
            this.ringBufferCapacity.completeRead(this.locked);
            this.locked = 0;
        }
        Object object = this.current.tryWriteSuspend$ktor_io(n, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object tryAwaitJoinSwitch(int n, @NotNull ByteBufferChannel.JoiningState joining, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof tryAwaitJoinSwitch.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ WriteSessionImpl this$0;
                Object L$0;
                Object L$1;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tryAwaitJoinSwitch(0, null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = writeSessionImpl;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.locked > 0) {
                    this.ringBufferCapacity.completeRead(this.locked);
                    this.locked = 0;
                }
                this.flush();
                this.current.restoreStateAfterWrite$ktor_io();
                this.current.tryTerminate$ktor_io();
                $continuation.L$0 = this;
                $continuation.I$0 = n;
                $continuation.L$1 = joining;
                $continuation.label = 1;
                v0 = this.current.tryWriteSuspend$ktor_io(n, (Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                joining = (ByteBufferChannel.JoiningState)$continuation.L$1;
                n = $continuation.I$0;
                this = (WriteSessionImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                this.current = this.current.resolveChannelInstance$ktor_io();
                v1 = this.current.setupStateForWrite$ktor_io();
                if (v1 == null) {
                } else {
                    this.byteBuffer = v1;
                    this.view = new IoBuffer(this.current.currentState$ktor_io().backingBuffer);
                    this.view.resetFromContentToWrite(this.byteBuffer);
                    this.ringBufferCapacity = this.current.currentState$ktor_io().capacity;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void flush() {
        this.current.flush();
    }

    private final void prepareBuffer(@NotNull ByteBuffer $this$prepareBuffer, ByteOrder order, int position, int available) {
        boolean bl = position >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = available >= 0;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int bufferLimit = $this$prepareBuffer.capacity() - this.current.getReservedSize$ktor_io();
        int virtualLimit = position + available;
        $this$prepareBuffer.order(order.getNioOrder());
        $this$prepareBuffer.limit(RangesKt.coerceAtMost((int)virtualLimit, (int)bufferLimit));
        $this$prepareBuffer.position(position);
    }

    public WriteSessionImpl(@NotNull ByteBufferChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.current = channel.resolveChannelInstance$ktor_io();
        this.byteBuffer = IoBuffer.Companion.getEmpty().getMemory();
        this.view = IoBuffer.Companion.getEmpty();
        this.ringBufferCapacity = this.current.currentState$ktor_io().capacity;
    }
}

