/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.ObjectPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0004J\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\f\u0010\u0006J\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000bR\u0013\u0010\u0011\u001a\u00020\u000e8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\t\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/utils/io/pool/SingleInstancePool;", "", "T", "<init>", "()V", "borrow", "()Ljava/lang/Object;", "", "dispose", "instance", "disposeInstance", "(Ljava/lang/Object;)V", "produceInstance", "recycle", "", "getCapacity", "()I", "capacity", "Ljava/lang/Object;", "ktor-io", "Lio/ktor/utils/io/pool/ObjectPool;"})
public abstract class SingleInstancePool<T>
implements ObjectPool<T> {
    private volatile /* synthetic */ int borrowed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater borrowed$FU;
    private volatile /* synthetic */ int disposed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater disposed$FU;
    private volatile T instance;

    @NotNull
    protected abstract T produceInstance();

    protected abstract void disposeInstance(@NotNull T var1);

    @Override
    public final int getCapacity() {
        return 1;
    }

    @Override
    @NotNull
    public final T borrow() {
        int upd$iv;
        int cur$iv;
        SingleInstancePool $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int it = cur$iv = $this$update$iv.borrowed;
            boolean bl = false;
            if (it == 0) continue;
            throw (Throwable)new IllegalStateException("Instance is already consumed");
        } while (!borrowed$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = 1));
        T instance = this.produceInstance();
        this.instance = instance;
        return instance;
    }

    @Override
    public final void recycle(@NotNull T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        if (this.instance != instance) {
            if (this.instance == null && this.borrowed != 0) {
                throw (Throwable)new IllegalStateException("Already recycled or an irrelevant instance tried to be recycled");
            }
            throw (Throwable)new IllegalStateException("Unable to recycle irrelevant instance");
        }
        this.instance = null;
        if (!disposed$FU.compareAndSet(this, 0, 1)) {
            throw (Throwable)new IllegalStateException("An instance is already disposed");
        }
        this.disposeInstance(instance);
    }

    @Override
    public final void dispose() {
        if (disposed$FU.compareAndSet(this, 0, 1)) {
            T t = this.instance;
            if (t == null) {
                return;
            }
            T instance = t;
            this.instance = null;
            this.disposeInstance(instance);
        }
    }

    public SingleInstancePool() {
        this.borrowed = 0;
        this.disposed = 0;
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }

    static {
        borrowed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "borrowed");
        disposed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "disposed");
    }
}

