/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificateInfo;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.Counterparty;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import java.io.ByteArrayInputStream;
import java.net.Inet4Address;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\r\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lio/ktor/network/tls/certificates/CertificateBuilder;", "", "()V", "daysValid", "", "getDaysValid", "()J", "setDaysValid", "(J)V", "hash", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "getHash", "()Lio/ktor/network/tls/extensions/HashAlgorithm;", "setHash", "(Lio/ktor/network/tls/extensions/HashAlgorithm;)V", "keySizeInBits", "", "getKeySizeInBits", "()I", "setKeySizeInBits", "(I)V", "password", "", "getPassword", "()Ljava/lang/String;", "setPassword", "(Ljava/lang/String;)V", "sign", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "getSign", "()Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "setSign", "(Lio/ktor/network/tls/extensions/SignatureAlgorithm;)V", "build", "Lio/ktor/network/tls/certificates/CertificateInfo;", "build$ktor_network_tls_certificates", "ktor-network-tls-certificates"})
public final class CertificateBuilder {
    public HashAlgorithm hash;
    public SignatureAlgorithm sign;
    public String password;
    private long daysValid = 3L;
    private int keySizeInBits = 1024;

    @NotNull
    public final HashAlgorithm getHash() {
        HashAlgorithm hashAlgorithm = this.hash;
        if (hashAlgorithm != null) {
            return hashAlgorithm;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"hash");
        throw null;
    }

    public final void setHash(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, (String)"<set-?>");
        this.hash = hashAlgorithm;
    }

    @NotNull
    public final SignatureAlgorithm getSign() {
        SignatureAlgorithm signatureAlgorithm = this.sign;
        if (signatureAlgorithm != null) {
            return signatureAlgorithm;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sign");
        throw null;
    }

    public final void setSign(@NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"<set-?>");
        this.sign = signatureAlgorithm;
    }

    @NotNull
    public final String getPassword() {
        String string = this.password;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"password");
        throw null;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    public final long getDaysValid() {
        return this.daysValid;
    }

    public final void setDaysValid(long l) {
        this.daysValid = l;
    }

    public final int getKeySizeInBits() {
        return this.keySizeInBits;
    }

    public final void setKeySizeInBits(int n) {
        this.keySizeInBits = n;
    }

    @NotNull
    public final CertificateInfo build$ktor_network_tls_certificates() {
        byte[] certificateBytes;
        ByteReadPacket byteReadPacket;
        HashAndSign algorithm = new HashAndSign(this.getHash(), this.getSign(), null, 4, null);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm((String)algorithm.getName()));
        Intrinsics.checkNotNull((Object)keyPairGenerator);
        boolean bl = false;
        boolean bl2 = false;
        KeyPairGenerator $this$build_u24lambda_u2d0 = keyPairGenerator;
        boolean bl3 = false;
        $this$build_u24lambda_u2d0.initialize(this.getKeySizeInBits());
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Intrinsics.checkNotNull((Object)keyPair);
        KeyPair keys = keyPair;
        Counterparty id = new Counterparty("RU", "JetBrains", "Kotlin", "localhost");
        Date from = new Date();
        Date to = Date.from(LocalDateTime.now().plusDays(this.daysValid).atZone(ZoneId.systemDefault()).toInstant());
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl4 = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$build_u24lambda_u2d1 = builder$iv;
            boolean bl5 = false;
            String string = algorithm.getName();
            Intrinsics.checkNotNullExpressionValue((Object)to, (String)"to");
            CertificatesKt.writeCertificate($this$build_u24lambda_u2d1, id, id, keys, string, from, to, CollectionsKt.listOf((Object)"localhost"), CollectionsKt.listOf((Object)Inet4Address.getByName("127.0.0.1")));
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        byte[] byArray = certificateBytes = StringsKt.readBytes$default((ByteReadPacket)byteReadPacket, (int)0, (int)1, null);
        boolean bl6 = false;
        Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
        cert.verify(keys.getPublic());
        Intrinsics.checkNotNullExpressionValue((Object)cert, (String)"cert");
        return new CertificateInfo(cert, keys, this.getPassword());
    }
}

