/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.application.ApplicationCall;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.netty.NettyCallPool;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.server.netty.NettyConnectionPool;
import io.ktor.server.netty.NettyDispatcher;
import io.ktor.server.netty.NettyWorkerPool;
import io.ktor.util.DispatcherWithShutdown;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "bootstraps", "", "Lio/netty/bootstrap/ServerBootstrap;", "callEventGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "cancellationDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "channels", "Lio/netty/channel/Channel;", "configuration", "connectionEventGroup", "Lio/ktor/server/netty/NettyConnectionPool;", "dispatcherWithShutdown", "Lio/ktor/util/DispatcherWithShutdown;", "engineDispatcherWithShutdown", "workerEventGroup", "Lio/ktor/server/netty/NettyWorkerPool;", "start", "wait", "", "stop", "gracePeriod", "", "timeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "toString", "", "Configuration", "ktor-server-netty"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    private final Configuration configuration;
    private final NettyConnectionPool connectionEventGroup;
    private final NettyWorkerPool workerEventGroup;
    private final NioEventLoopGroup callEventGroup;
    private final DispatcherWithShutdown dispatcherWithShutdown;
    private final DispatcherWithShutdown engineDispatcherWithShutdown;
    private CompletableDeferred<Unit> cancellationDeferred;
    private List<? extends Channel> channels;
    private final List<ServerBootstrap> bootstraps;

    @NotNull
    public NettyApplicationEngine start(boolean wait) {
        ChannelFuture channelFuture;
        ChannelFuture it;
        Collection<ChannelFuture> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.getEnvironment().start();
        Iterable iterable = CollectionsKt.zip((Iterable)this.bootstraps, (Iterable)this.getEnvironment().getConnectors());
        Object object = this;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            channelFuture = ((ServerBootstrap)it.getFirst()).bind(((EngineConnectorConfig)it.getSecond()).getHost(), ((EngineConnectorConfig)it.getSecond()).getPort());
            collection.add(channelFuture);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ChannelFuture)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            channelFuture = it.sync().channel();
            collection.add(channelFuture);
        }
        collection = (List)destination$iv$iv;
        ((NettyApplicationEngine)((Object)object)).channels = collection;
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)this);
        if (wait) {
            List<? extends Channel> list = this.channels;
            if (list != null) {
                $receiver$iv$iv = $receiver$iv = (Iterable)list;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (Channel)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    collection = it.closeFuture();
                    object.add(collection);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    ChannelFuture it2 = (ChannelFuture)element$iv;
                    boolean bl = false;
                    it2.sync();
                }
            }
            this.stop(1L, 5L, TimeUnit.SECONDS);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void stop(long gracePeriod, long timeout, @NotNull TimeUnit timeUnit) {
        Iterable iterable;
        List list;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        CompletableDeferred<Unit> completableDeferred = this.cancellationDeferred;
        if (completableDeferred != null) {
            completableDeferred.complete((Object)Unit.INSTANCE);
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        List<? extends Channel> list2 = this.channels;
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChannelFuture channelFuture;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Channel it = (Channel)element$iv$iv;
                boolean bl = false;
                ChannelFuture channelFuture2 = it.isOpen() ? it.close() : null;
                if (channelFuture2 == null) continue;
                ChannelFuture it$iv$iv = channelFuture = channelFuture2;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        if ((iterable = ($receiver$iv = list)) == null) {
            iterable = CollectionsKt.emptyList();
        }
        Iterable channelFutures = iterable;
        this.dispatcherWithShutdown.prepareShutdown();
        this.engineDispatcherWithShutdown.prepareShutdown();
        try {
            Future shutdownConnections = this.connectionEventGroup.shutdownGracefully(gracePeriod, timeout, timeUnit);
            shutdownConnections.await();
            Future shutdownWorkers = this.workerEventGroup.shutdownGracefully(gracePeriod, timeout, timeUnit);
            if (this.configuration.getShareWorkGroup()) {
                shutdownWorkers.await();
            } else {
                Future shutdownCall = this.callEventGroup.shutdownGracefully(gracePeriod, timeout, timeUnit);
                shutdownWorkers.await();
                shutdownCall.await();
            }
            this.getEnvironment().stop();
        }
        finally {
            this.dispatcherWithShutdown.completeShutdown();
            this.engineDispatcherWithShutdown.completeShutdown();
            $receiver$iv = channelFutures;
            for (Object element$iv : $receiver$iv) {
                ChannelFuture it = (ChannelFuture)element$iv;
                boolean bl = false;
                it.sync();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    /*
     * WARNING - void declaration
     */
    public NettyApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(configure, (String)"configure");
        super(environment, null, 2, null);
        Object object = new Configuration();
        NettyApplicationEngine nettyApplicationEngine = this;
        configure.invoke(object);
        Object object2 = object;
        nettyApplicationEngine.configuration = object2;
        this.connectionEventGroup = new NettyConnectionPool(this.configuration.getConnectionGroupSize());
        this.workerEventGroup = this.configuration.getShareWorkGroup() ? new NettyWorkerPool(this.configuration.getWorkerGroupSize() + this.configuration.getCallGroupSize()) : new NettyWorkerPool(this.configuration.getWorkerGroupSize());
        this.callEventGroup = this.configuration.getShareWorkGroup() ? (NioEventLoopGroup)this.workerEventGroup : (NioEventLoopGroup)new NettyCallPool(this.configuration.getCallGroupSize());
        this.dispatcherWithShutdown = new DispatcherWithShutdown((CoroutineDispatcher)NettyDispatcher.INSTANCE);
        this.engineDispatcherWithShutdown = new DispatcherWithShutdown((CoroutineDispatcher)ExecutorsKt.from((ExecutorService)((ExecutorService)((Object)this.workerEventGroup))));
        object = environment.getConnectors();
        nettyApplicationEngine = this;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void connector;
            ServerBootstrap serverBootstrap;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            ServerBootstrap $receiver = serverBootstrap = new ServerBootstrap();
            boolean bl2 = false;
            this.configuration.getConfigureBootstrap().invoke((Object)$receiver);
            $receiver.group((EventLoopGroup)this.connectionEventGroup, (EventLoopGroup)this.workerEventGroup);
            $receiver.channel(NioServerSocketChannel.class);
            $receiver.childHandler((ChannelHandler)new NettyChannelInitializer(this.getPipeline(), environment, (EventExecutorGroup)this.callEventGroup, (CoroutineContext)this.engineDispatcherWithShutdown, (CoroutineContext)this.dispatcherWithShutdown, (EngineConnectorConfig)connector, this.configuration.getRequestQueueLimit(), this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getHttpServerCodec()));
            ServerBootstrap serverBootstrap2 = serverBootstrap;
            object2.add(serverBootstrap2);
        }
        object2 = (List)destination$iv$iv;
        nettyApplicationEngine.bootstraps = object2;
        PipelinePhase afterCall = new PipelinePhase("After");
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), afterCall);
        this.getPipeline().intercept(afterCall, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(null){
            private PipelineContext p$;
            private Unit p$0;
            int label;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        v0 = result;
                        if (v0 instanceof Result.Failure) {
                            throw ((Result.Failure)v0).exception;
                        }
                        var2_3 = this.p$;
                        var3_4 = this.p$0;
                        $receiver$iv = var2_3;
                        $i$f$getCall = false;
                        v1 = (ApplicationCall)$receiver$iv.getContext();
                        if (!(v1 instanceof NettyApplicationCall)) {
                            v1 = null;
                        }
                        v2 = (NettyApplicationCall)v1;
                        if (v2 == null) break;
                        var4_5 = v2;
                        this.label = 1;
                        v3 = var4_5.finish$ktor_server_netty((Continuation<? super Unit>)this);
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        v4 = result;
                        if (v4 instanceof Result.Failure) {
                            throw ((Result.Failure)v4).exception;
                        }
                        v3 = result;
lbl27:
                        // 2 sources

                        (Unit)v3;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull PipelineContext<Unit, ApplicationCall> $receiver, @NotNull Unit it, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                PipelineContext<Unit, ApplicationCall> pipelineContext = function3.p$ = $receiver;
                Unit unit = function3.p$0 = it;
                return function3;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((PipelineContext<Unit, ApplicationCall>)((PipelineContext)object), (Unit)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public /* synthetic */ NettyApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(applicationEngineEnvironment, (Function1<? super Configuration, Unit>)function1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureBootstrap", "Lkotlin/Function1;", "Lio/netty/bootstrap/ServerBootstrap;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureBootstrap", "()Lkotlin/jvm/functions/Function1;", "setConfigureBootstrap", "(Lkotlin/jvm/functions/Function1;)V", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "requestQueueLimit", "", "getRequestQueueLimit", "()I", "setRequestQueueLimit", "(I)V", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "runningLimit", "getRunningLimit", "setRunningLimit", "shareWorkGroup", "", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int requestQueueLimit = 16;
        private int runningLimit = 10;
        private boolean shareWorkGroup;
        @NotNull
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = configureBootstrap.1.INSTANCE;
        private int responseWriteTimeoutSeconds = 10;
        @NotNull
        private Function0<HttpServerCodec> httpServerCodec = httpServerCodec.1.INSTANCE;

        public final int getRequestQueueLimit() {
            return this.requestQueueLimit;
        }

        public final void setRequestQueueLimit(int n) {
            this.requestQueueLimit = n;
        }

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n) {
            this.runningLimit = n;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        @NotNull
        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(@NotNull Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n) {
            this.responseWriteTimeoutSeconds = n;
        }

        @NotNull
        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(@NotNull Function0<HttpServerCodec> function0) {
            Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
            this.httpServerCodec = function0;
        }
    }
}

